/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.tfcagedalcohol.client;

import com.hermitowo.tfcagedalcohol.common.AgedAlcoholFluids;
import com.hermitowo.tfcagedalcohol.config.Config;
import net.dries007.tfc.common.fluids.FluidRegistryObject;
import net.dries007.tfc.util.Drinkable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;

public class ClientForgeEvents {
    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(ClientForgeEvents::onTooltip);
    }

    private static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(cap -> {
            FluidStack fluidStack = cap.getFluidInTank(0);
            if (!fluidStack.isEmpty()) {
                Drinkable drinkable;
                Drinkable alcohol = AgedAlcoholFluids.AGED_ALCOHOL.entrySet().stream().filter(entry -> ((FluidRegistryObject)entry.getValue()).getSource() == fluidStack.getFluid()).findAny().map(entry -> Drinkable.get((Fluid)((FluidRegistryObject)entry.getValue()).getSource())).orElse(null);
                Drinkable drinkable2 = drinkable = (Boolean)Config.CLIENT.showEffectTooltipForAllDrinkables.get() != false ? Drinkable.get((Fluid)fluidStack.getFluid()) : alcohol;
                if (drinkable != null) {
                    drinkable.getEffects().stream().findAny().map(effect -> event.getToolTip().add(ClientForgeEvents.getTooltip(effect.type(), effect.duration(), effect.amplifier())));
                }
            }
        });
    }

    private static Component getTooltip(MobEffect effect, int duration, int amplifier) {
        MobEffectInstance effectInstance = new MobEffectInstance(effect, duration, amplifier);
        return Component.m_237113_((String)(effect.m_19482_().getString() + ClientForgeEvents.displayedPotency(amplifier) + "(" + ClientForgeEvents.formatDuration(effectInstance) + ")")).m_130940_(effect.m_19483_().m_19497_());
    }

    private static String displayedPotency(int amplifier) {
        return switch (amplifier + 1) {
            case 2 -> " II ";
            case 3 -> " III ";
            default -> " ";
        };
    }

    private static String formatDuration(MobEffectInstance effect) {
        return StringUtil.m_14404_((int)Mth.m_14143_((float)effect.m_19557_()));
    }
}

