/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import snownee.jade.gui.config.OptionsList;

public abstract class OptionValue<T>
extends OptionsList.Entry {
    private static final Component SERVER_FEATURE = Component.m_237113_((String)"*").m_130940_(ChatFormatting.GRAY);
    protected final Consumer<T> setter;
    private final Component title;
    public boolean serverFeature;
    protected T value;
    protected int indent;
    private int x;

    public OptionValue(String optionName, Consumer<T> setter) {
        this.title = OptionValue.makeTitle(optionName);
        this.setter = setter;
        this.addMessage(this.title.getString());
        this.addMessageKey(optionName);
        String key = OptionValue.makeKey(optionName + "_desc");
        if (I18n.m_118936_((String)key)) {
            this.appendDescription(I18n.m_118938_((String)key, (Object[])new Object[0]));
        }
    }

    @Override
    public final void m_6311_(GuiGraphics guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        AbstractWidget widget = this.getFirstWidget();
        Component title0 = widget.f_93623_ ? this.title : this.title.m_6881_().m_130944_(new ChatFormatting[]{ChatFormatting.STRIKETHROUGH, ChatFormatting.GRAY});
        int left = rowLeft + this.indent + 10;
        int n = rowTop + height / 2;
        Objects.requireNonNull(this.client.f_91062_);
        int top = n - 9 / 2;
        guiGraphics.m_280430_(this.client.f_91062_, title0, left, top, 0xFFFFFF);
        if (this.serverFeature) {
            guiGraphics.m_280430_(this.client.f_91062_, SERVER_FEATURE, left + this.getTextWidth() + 1, top, 0xFFFFFF);
        }
        super.m_6311_(guiGraphics, index, rowTop, rowLeft, width, height, mouseX, mouseY, hovered, deltaTime);
        this.x = rowLeft;
    }

    public void save() {
        this.setter.accept(this.value);
    }

    public Component getTitle() {
        return this.title;
    }

    public void appendDescription(String description) {
        this.description = this.description == null ? description : this.description + "\n" + description;
        this.addMessage(description);
    }

    public int getX() {
        return this.x;
    }

    @Override
    public int getTextX(int width) {
        return this.getX() + this.indent + 10;
    }

    @Override
    public int getTextWidth() {
        return this.client.f_91062_.m_92852_((FormattedText)this.getTitle());
    }

    public void m_168854_(NarrationElementOutput output) {
        super.m_168854_(output);
        if (!Strings.isNullOrEmpty((String)this.getDescription())) {
            output.m_169146_(NarratedElementType.HINT, (Component)Component.m_237115_((String)this.getDescription()));
        }
    }

    public boolean isValidValue() {
        return true;
    }

    @Override
    public OptionsList.Entry parent(OptionsList.Entry parent) {
        super.parent(parent);
        if (parent instanceof OptionValue) {
            this.indent = ((OptionValue)parent).indent + 12;
        }
        return this;
    }

    public abstract void setValue(T var1);
}

