/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.plant;

import com.eerussianguy.firmalife.common.blockentities.GrapePlantBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.plant.GrapeGroundPlantOnStringBlock;
import com.eerussianguy.firmalife.common.blocks.plant.GrapeStringBlock;
import com.eerussianguy.firmalife.common.blocks.plant.GrapeTrellisPostBlock;
import com.eerussianguy.firmalife.common.blocks.plant.GrapeTrellisPostWithPlantBlock;
import com.eerussianguy.firmalife.common.blocks.plant.IGrape;
import java.util.List;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;

public class GrapeStringWithPlantBlock
extends GrapeStringBlock
implements IGrape {
    public static final EnumProperty<Lifecycle> LIFECYCLE = TFCBlockStateProperties.LIFECYCLE;
    public static final VoxelShape SHAPE = GrapeStringWithPlantBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final Supplier<? extends Block> postPlantBlock;
    private final Supplier<? extends Block> fluffBlock;
    private final Supplier<? extends Item> grapeItem;

    public GrapeStringWithPlantBlock(ExtendedProperties properties, Supplier<? extends Block> postPlantBlock, Supplier<? extends Block> fluffBlock, Supplier<? extends Item> grape) {
        super(properties);
        this.postPlantBlock = postPlantBlock;
        this.fluffBlock = fluffBlock;
        this.grapeItem = grape;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(LIFECYCLE, (Comparable)Lifecycle.HEALTHY));
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        BlockState superState = super.m_7417_(state, facing, facingState, level, pos, facingPos);
        if (superState.m_60795_()) {
            return superState;
        }
        if (facing == Direction.DOWN && !(facingState.m_60734_() instanceof GrapeGroundPlantOnStringBlock)) {
            return Helpers.copyProperty((BlockState)((Block)FLBlocks.GRAPE_STRING.get()).m_49966_(), (BlockState)state, (Property)AXIS);
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (state.m_61143_(LIFECYCLE) == Lifecycle.FRUITING) {
            level.m_5594_(player, pos, SoundEvents.f_12457_, SoundSource.PLAYERS, 1.0f, level.m_213780_().m_188501_() + 0.7f + 0.3f);
            ItemStack stack = this.grapeItem.get().m_7968_();
            BlockEntity blockEntity = level.m_7702_(pos.m_7495_());
            if (blockEntity instanceof GrapePlantBlockEntity) {
                GrapePlantBlockEntity grape = (GrapePlantBlockEntity)blockEntity;
                List<FoodTrait> traits = grape.scanAndReport();
                for (FoodTrait trait : traits) {
                    FoodCapability.applyTrait((ItemStack)stack, (FoodTrait)trait);
                }
            }
            FoodCapability.updateFoodDecayOnCreate((ItemStack)stack);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            level.m_46597_(pos, (BlockState)state.m_61124_(LIFECYCLE, (Comparable)Lifecycle.HEALTHY));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Override
    public void advance(Level level, BlockPos pos, BlockState state) {
        Direction dir = state.m_61143_((Property)AXIS) == Direction.Axis.X ? Direction.EAST : Direction.SOUTH;
        this.convertToPlant(level, pos.m_121945_(dir));
        this.convertToPlant(level, pos.m_121945_(dir.m_122424_()));
        BlockPos above = pos.m_7494_();
        if (level.m_8055_(above).m_60795_()) {
            level.m_46597_(above, this.fluffBlock.get().m_49966_());
        }
    }

    @Override
    public void advanceLifecycle(Level level, BlockPos pos, BlockState state, Lifecycle lifecycle) {
        this.updateLifecycle(level, pos, state, lifecycle);
        Direction dir = state.m_61143_((Property)AXIS) == Direction.Axis.X ? Direction.EAST : Direction.SOUTH;
        this.updateLifecycle(level, pos.m_121945_(dir), level.m_8055_(pos.m_121945_(dir)), lifecycle);
        this.updateLifecycle(level, pos.m_121945_(dir.m_122424_()), level.m_8055_(pos.m_121945_(dir.m_122424_())), lifecycle);
    }

    private void convertToPlant(Level level, BlockPos pos) {
        BlockPos above;
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof GrapeTrellisPostBlock && !(state.m_60734_() instanceof GrapeTrellisPostWithPlantBlock)) {
            level.m_46597_(pos, Helpers.copyProperties((BlockState)this.postPlantBlock.get().m_49966_(), (BlockState)state));
        }
        if (level.m_8055_(above = pos.m_7494_()).m_60795_()) {
            level.m_46597_(above, this.fluffBlock.get().m_49966_());
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.m_61143_((Property)AXIS) == Direction.Axis.X ? SHAPE_X : SHAPE_Z;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{LIFECYCLE}));
    }
}

