/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.blockentities.CompostTumblerBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FourWayDeviceBlock;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CompostTumblerBlock
extends FourWayDeviceBlock {
    public static final VoxelShape[] SHAPES = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)1.0, (double)16.0), Helpers.rotateShape((Direction)dir, (double)14.0, (double)0.0, (double)2.0, (double)16.0, (double)1.0, (double)16.0), Helpers.rotateShape((Direction)dir, (double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)3.0), Helpers.rotateShape((Direction)dir, (double)7.0, (double)2.0, (double)0.0, (double)9.0, (double)7.0, (double)2.0), Helpers.rotateShape((Direction)dir, (double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)13.0, (double)16.0)}));

    public CompostTumblerBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        CompostTumblerBlockEntity tumbler;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CompostTumblerBlockEntity && (tumbler = (CompostTumblerBlockEntity)blockEntity).isReady()) {
            SimpleParticleType particle = !tumbler.isRotten() ? ((SimpleParticleType)TFCParticles.COMPOST_READY.get()).m_6012_() : ((SimpleParticleType)TFCParticles.COMPOST_ROTTEN.get()).m_6012_();
            double x = (double)pos.m_123341_() + random.m_188500_();
            double y = (double)(pos.m_123342_() + 1) + random.m_188500_() / 5.0;
            double z = (double)pos.m_123343_() + random.m_188500_();
            int count = Mth.m_216271_((RandomSource)random, (int)0, (int)4);
            for (int i = 0; i < count; ++i) {
                level.m_7106_((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        CompostTumblerBlockEntity composter;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CompostTumblerBlockEntity && (composter = (CompostTumblerBlockEntity)blockEntity).getRotationNode().rotation() == null) {
            return composter.use(player.m_21120_(hand), player, level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int id = ((Direction)state.m_61143_((Property)FACING)).m_122416_();
        return SHAPES[id];
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CompostTumblerBlockEntity) {
            CompostTumblerBlockEntity tumbler = (CompostTumblerBlockEntity)blockEntity;
            tumbler.resetCounter();
        }
    }
}

