/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.recipes.StompingRecipe;
import java.util.Collections;
import java.util.List;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class StompingBarrelBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    public static final int MAX_GRAPES = 16;
    private int stomps = 0;
    @Nullable
    private ResourceLocation texture;
    private boolean isOutputMode = false;

    public StompingBarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.STOMPING_BARREL.get(), pos, state, StompingBarrelBlockEntity.defaultInventory((int)1), FLHelpers.blockEntityName("stomping_barrel"));
    }

    public void stomp(Entity entity) {
        assert (this.f_58857_ != null);
        if (entity instanceof LivingEntity) {
            ItemStack current = ((ItemStackHandler)this.inventory).getStackInSlot(0);
            StompingRecipe recipe = StompingRecipe.getRecipe(this.f_58857_, new ItemStackInventory(current));
            if (recipe == null) {
                return;
            }
            ++this.stomps;
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            Helpers.playSound((Level)this.f_58857_, (BlockPos)this.f_58858_, (SoundEvent)recipe.getSound());
            if (this.stomps > 16) {
                List traits = current.getCapability(FoodCapability.CAPABILITY).map(IFood::getTraits).orElse(Collections.emptyList());
                ItemStack newStack = recipe.assemble(new ItemStackInventory(current), this.f_58857_.m_9598_());
                newStack.m_41764_(newStack.m_41613_() * current.m_41613_());
                for (FoodTrait trait : traits) {
                    FoodCapability.applyTrait((ItemStack)newStack, (FoodTrait)trait);
                }
                if (newStack.m_41613_() > 16) {
                    Helpers.spawnItem((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)newStack.m_41620_(newStack.m_41613_() - 16));
                }
                ((ItemStackHandler)this.inventory).setStackInSlot(0, newStack);
                Helpers.playSound((Level)this.f_58857_, (BlockPos)this.f_58858_, (SoundEvent)recipe.getSound());
                this.stomps = 0;
                this.isOutputMode = true;
                this.texture = recipe.getOutputTexture();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
                this.markForSync();
            }
        }
    }

    @Nullable
    public ResourceLocation getTexture() {
        return this.texture;
    }

    public boolean isOutputMode() {
        return this.isOutputMode;
    }

    public int getStomps() {
        return this.stomps;
    }

    public ItemStack readStack() {
        return ((ItemStackHandler)this.inventory).getStackInSlot(0);
    }

    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.stomps = nbt.m_128451_("stomps");
        this.isOutputMode = nbt.m_128471_("isOutput");
        if (nbt.m_128425_("texture", 8)) {
            this.texture = FLHelpers.res(nbt.m_128461_("texture"));
        }
        this.causeTextureUpdate();
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("stomps", this.stomps);
        nbt.m_128379_("isOutput", this.isOutputMode);
        if (this.texture != null) {
            nbt.m_128359_("texture", this.texture.toString());
        }
    }

    public void causeTextureUpdate() {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack current = ((ItemStackHandler)this.inventory).getStackInSlot(0);
        if (current.m_41619_()) {
            this.texture = null;
            this.isOutputMode = false;
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.markForSync();
            return;
        }
        StompingRecipe recipe = StompingRecipe.getRecipe(this.f_58857_, new ItemStackInventory(current));
        if (this.stomps == 0 && recipe != null) {
            this.texture = recipe.getInputTexture();
            this.isOutputMode = false;
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
            this.markForSync();
        }
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
        this.stomps = 0;
        this.causeTextureUpdate();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        assert (this.f_58857_ != null);
        return StompingRecipe.getRecipe(this.f_58857_, new ItemStackInventory(stack)) != null;
    }

    public int getSlotStackLimit(int slot) {
        return 16;
    }
}

