/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.VatBlockEntity;
import com.eerussianguy.firmalife.common.blocks.JarringStationBlock;
import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class JarringStationBlockEntity
extends TickableInventoryBlockEntity<ItemStackHandler> {
    public static final int SLOTS = 9;
    private int pourTicks = 0;

    public static void tick(Level level, BlockPos pos, BlockState state, JarringStationBlockEntity station) {
        VatBlockEntity vat;
        BlockEntity blockEntity;
        station.checkForLastTickSync();
        if (station.pourTicks > 0) {
            --station.pourTicks;
        }
        if (level.m_46467_() % 60L == 0L && state.m_61138_((Property)JarringStationBlock.FACING) && (blockEntity = level.m_7702_(pos.m_121945_((Direction)state.m_61143_((Property)JarringStationBlock.FACING)))) instanceof VatBlockEntity && (vat = (VatBlockEntity)blockEntity).hasOutput()) {
            ItemStack jars = vat.getOutput();
            for (int i = 0; i < 9; ++i) {
                if (Helpers.isItem((Item)((ItemStackHandler)station.inventory).getStackInSlot(i).m_41720_(), (TagKey)TFCTags.Items.EMPTY_JAR_WITH_LID)) {
                    Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11770_);
                    ((ItemStackHandler)station.inventory).setStackInSlot(i, jars.m_41620_(1));
                    station.markForSync();
                    vat.markForSync();
                    station.pourTicks = 45;
                }
                if (jars.m_41619_()) break;
            }
        }
    }

    public JarringStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.JARRING_STATION.get(), pos, state, JarringStationBlockEntity.defaultInventory((int)9), FLHelpers.blockEntityName("jarring_station"));
        this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).extractAll(), new Direction[]{Direction.DOWN}).on((Object)new PartialItemHandler(this.inventory).insertAll(), (Predicate)Direction.Plane.HORIZONTAL);
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem((ItemStack)stack, (TagKey)TFCTags.Items.EMPTY_JAR_WITH_LID);
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }
}

