/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.OvenBottomBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.OvenTopBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.FLFluids;
import com.eerussianguy.firmalife.common.blocks.JarbnetBlock;
import com.eerussianguy.firmalife.common.blocks.OvenBottomBlock;
import com.eerussianguy.firmalife.common.blocks.OvenTopBlock;
import com.eerussianguy.firmalife.common.capabilities.player.FLPlayerData;
import com.eerussianguy.firmalife.common.capabilities.player.FLPlayerDataCapability;
import com.eerussianguy.firmalife.common.network.FLPackets;
import com.eerussianguy.firmalife.common.util.ExtraFluid;
import com.eerussianguy.firmalife.common.util.FLSelfTests;
import com.eerussianguy.firmalife.common.util.GreenhouseType;
import com.eerussianguy.firmalife.common.util.Plantable;
import net.dries007.tfc.common.entities.TFCEntities;
import net.dries007.tfc.common.items.CandleBlockItem;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.dries007.tfc.util.events.DouseFireEvent;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class FLForgeEvents {
    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(FLForgeEvents::onFireStart);
        bus.addListener(FLForgeEvents::onFireStop);
        bus.addListener(FLForgeEvents::addReloadListeners);
        bus.addListener(FLForgeEvents::onDataPackSync);
        bus.addListener(FLForgeEvents::onAnimalProduce);
        bus.addListener(FLForgeEvents::onLogin);
        bus.addListener(FLForgeEvents::onLevelLoad);
    }

    public static void onLevelLoad(LevelEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
            FLSelfTests.runServerSelfTests();
        }
    }

    public static void onEntityCaps(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(FLPlayerDataCapability.KEY, (ICapabilityProvider)new FLPlayerData(player));
        }
    }

    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        TFCConfig.SERVER.enablePumpkinCarving.set((Object)false);
    }

    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener(GreenhouseType.MANAGER);
        event.addListener(Plantable.MANAGER);
    }

    public static void onDataPackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        PacketDistributor.PacketTarget target = player == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> player);
        FLPackets.send(target, GreenhouseType.MANAGER.createSyncPacket());
        FLPackets.send(target, Plantable.MANAGER.createSyncPacket());
    }

    public static void onFireStart(StartFireEvent event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Block block = state.m_60734_();
        if (block instanceof OvenBottomBlock) {
            level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_BOTTOM.get()).ifPresent(oven -> oven.light(state));
            event.setCanceled(true);
        } else if (block instanceof CarvedPumpkinBlock) {
            FLBlocks.CARVED_PUMPKINS.forEach((carve, reg) -> {
                if (block == reg.get()) {
                    level.m_46597_(pos, Helpers.copyProperty((BlockState)((Block)FLBlocks.JACK_O_LANTERNS.get(carve).get()).m_49966_(), (BlockState)state, (Property)HorizontalDirectionalBlock.f_54117_));
                    FLHelpers.resetCounter(level, pos);
                    event.setCanceled(true);
                }
            });
        } else if (block instanceof JarbnetBlock) {
            FLHelpers.readInventory(level, pos, FLBlockEntities.JARBNET, (jarbnet, inv) -> {
                for (ItemStack stack : Helpers.iterate((IItemHandler)inv)) {
                    if (!(stack.m_41720_() instanceof CandleBlockItem)) continue;
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)JarbnetBlock.LIT, (Comparable)Boolean.valueOf(true)));
                    jarbnet.resetCounter();
                    event.setCanceled(true);
                    break;
                }
            });
        }
    }

    public static void onFireStop(DouseFireEvent event) {
        BlockEntity blockEntity;
        BlockState state = event.getState();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (state.m_60734_() instanceof OvenBottomBlock && (blockEntity = level.m_7702_(pos)) instanceof OvenBottomBlockEntity) {
            OvenBottomBlockEntity bottom = (OvenBottomBlockEntity)blockEntity;
            bottom.extinguish(state);
            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11937_);
            event.setCanceled(true);
        } else if (state.m_60734_() instanceof OvenTopBlock && (blockEntity = level.m_7702_(pos)) instanceof OvenTopBlockEntity) {
            OvenTopBlockEntity top = (OvenTopBlockEntity)blockEntity;
            top.extinguish();
            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11937_);
            event.setCanceled(true);
        }
    }

    public static void onAnimalProduce(AnimalProductEvent event) {
        EntityType type = event.getEntity().m_6095_();
        if (type == TFCEntities.YAK.get()) {
            event.setProduct(new FluidStack((Fluid)FLFluids.EXTRA_FLUIDS.get((Object)ExtraFluid.YAK_MILK).getSource(), 1000));
        } else if (type == TFCEntities.GOAT.get()) {
            event.setProduct(new FluidStack((Fluid)FLFluids.EXTRA_FLUIDS.get((Object)ExtraFluid.GOAT_MILK).getSource(), 1000));
        }
    }
}

