/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common;

import com.eerussianguy.firmalife.FirmaLife;
import com.eerussianguy.firmalife.common.blocks.FLBlocks;
import com.eerussianguy.firmalife.common.blocks.OvenType;
import com.eerussianguy.firmalife.common.blocks.greenhouse.Greenhouse;
import com.eerussianguy.firmalife.common.blocks.plant.FLFruitBlocks;
import com.eerussianguy.firmalife.common.items.FLItems;
import com.eerussianguy.firmalife.common.util.Carving;
import com.eerussianguy.firmalife.common.util.FLMetal;
import com.eerussianguy.firmalife.common.util.FLSelfTests;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCCreativeTabs;
import net.dries007.tfc.common.blocks.DecorationBlockRegistryObject;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class FLCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"firmalife");
    public static final RegistryObject<CreativeModeTab> FIRMALIFE = FLCreativeTabs.register("firmalife", () -> new ItemStack((ItemLike)FLBlocks.CURED_OVEN_TOP.get((Object)OvenType.BRICK).get()), FLCreativeTabs::fillFirmalifeTab);

    public static void fillFirmalifeTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output out) {
        FLCreativeTabs.accept(out, FLItems.HONEY_JAR);
        FLCreativeTabs.accept(out, FLItems.COMPOST_JAR);
        FLCreativeTabs.accept(out, FLItems.ROTTEN_COMPOST_JAR);
        FLCreativeTabs.accept(out, FLItems.GUANO_JAR);
        FLCreativeTabs.accept(out, FLItems.BEEHIVE_FRAME);
        FLCreativeTabs.accept(out, FLItems.CHEESECLOTH);
        FLCreativeTabs.accept(out, FLItems.FRUIT_LEAF);
        FLCreativeTabs.accept(out, FLItems.ICE_SHAVINGS);
        FLCreativeTabs.accept(out, FLItems.OVEN_INSULATION);
        FLCreativeTabs.accept(out, FLItems.PEEL);
        FLCreativeTabs.accept(out, FLItems.PIE_PAN);
        FLCreativeTabs.accept(out, FLItems.PINEAPPLE_YARN);
        FLCreativeTabs.accept(out, FLItems.PINEAPPLE_LEATHER);
        FLCreativeTabs.accept(out, FLItems.PINEAPPLE_FIBER);
        FLCreativeTabs.accept(out, FLItems.POTTERY_SHERD);
        FLCreativeTabs.accept(out, FLItems.BEESWAX);
        FLCreativeTabs.accept(out, FLItems.STAINLESS_STEEL_JAR_LID);
        FLCreativeTabs.accept(out, FLItems.EMPTY_JAR_WITH_STAINLESS_STEEL_LID);
        FLCreativeTabs.accept(out, FLItems.RAW_HONEY);
        FLCreativeTabs.accept(out, FLItems.RENNET);
        FLCreativeTabs.accept(out, FLItems.SEED_BALL);
        FLCreativeTabs.accept(out, FLItems.WATERING_CAN);
        FLCreativeTabs.accept(out, FLItems.BEEKEEPER_HELMET);
        FLCreativeTabs.accept(out, FLItems.BEEKEEPER_CHESTPLATE);
        FLCreativeTabs.accept(out, FLItems.BEEKEEPER_LEGGINGS);
        FLCreativeTabs.accept(out, FLItems.BEEKEEPER_BOOTS);
        FLCreativeTabs.accept(out, FLItems.CINNAMON_BARK);
        FLCreativeTabs.accept(out, FLItems.OLIVINE_WINE_BOTTLE);
        FLCreativeTabs.accept(out, FLItems.HEMATITIC_WINE_BOTTLE);
        FLCreativeTabs.accept(out, FLItems.VOLCANIC_WINE_BOTTLE);
        FLCreativeTabs.accept(out, FLItems.EMPTY_OLIVINE_WINE_BOTTLE);
        FLCreativeTabs.accept(out, FLItems.EMPTY_HEMATITIC_WINE_BOTTLE);
        FLCreativeTabs.accept(out, FLItems.EMPTY_VOLCANIC_WINE_BOTTLE);
        FLCreativeTabs.accept(out, FLItems.CORK);
        FLCreativeTabs.accept(out, FLItems.TIRAGE_MIXTURE);
        FLCreativeTabs.accept(out, FLItems.BOTTLE_LABEL);
        FLCreativeTabs.accept(out, FLItems.BARREL_STAVE);
        FLCreativeTabs.accept(out, FLItems.RED_GRAPE_SEEDS);
        FLCreativeTabs.accept(out, FLItems.WHITE_GRAPE_SEEDS);
        FLItems.SPICES.values().forEach(reg -> FLCreativeTabs.accept(out, reg));
        for (OvenType ovenType : OvenType.values()) {
            FLCreativeTabs.accept(out, FLBlocks.CURED_OVEN_BOTTOM, ovenType);
            FLCreativeTabs.accept(out, FLBlocks.INSULATED_OVEN_BOTTOM, ovenType);
            FLCreativeTabs.accept(out, FLBlocks.CURED_OVEN_TOP, ovenType);
            FLCreativeTabs.accept(out, FLBlocks.CURED_OVEN_CHIMNEY, ovenType);
            FLCreativeTabs.accept(out, FLBlocks.CURED_OVEN_HOPPER, ovenType);
            FLCreativeTabs.accept(out, FLBlocks.OVEN_COUNTERTOP, ovenType);
            FLCreativeTabs.accept(out, FLItems.FINISHES, ovenType);
            if (ovenType == OvenType.RUSTIC) {
                FLCreativeTabs.accept(out, FLBlocks.RUSTIC_BRICKS);
                FLCreativeTabs.accept(out, FLBlocks.RUSTIC_BRICK_DECOR);
                continue;
            }
            if (ovenType != OvenType.TILE) continue;
            FLCreativeTabs.accept(out, FLBlocks.TILES);
            FLCreativeTabs.accept(out, FLBlocks.TILE_DECOR);
        }
        FLCreativeTabs.accept(out, FLBlocks.OVEN_BOTTOM);
        FLCreativeTabs.accept(out, FLBlocks.OVEN_TOP);
        FLCreativeTabs.accept(out, FLBlocks.OVEN_CHIMNEY);
        FLCreativeTabs.accept(out, FLBlocks.OVEN_HOPPER);
        FLCreativeTabs.accept(out, FLBlocks.ASHTRAY);
        FLCreativeTabs.accept(out, FLBlocks.DRYING_MAT);
        FLCreativeTabs.accept(out, FLBlocks.SOLAR_DRIER);
        FLCreativeTabs.accept(out, FLBlocks.BEEHIVE);
        FLCreativeTabs.accept(out, FLBlocks.COMPOST_TUMBLER);
        FLCreativeTabs.accept(out, FLBlocks.MIXING_BOWL);
        FLCreativeTabs.accept(out, FLItems.SPOON);
        FLCreativeTabs.accept(out, FLBlocks.VAT);
        FLCreativeTabs.accept(out, FLBlocks.JARRING_STATION);
        FLCreativeTabs.accept(out, FLBlocks.PLATE);
        FLCreativeTabs.accept(out, FLBlocks.CLIMATE_STATION);
        FLCreativeTabs.accept(out, FLBlocks.LARGE_PLANTER);
        FLCreativeTabs.accept(out, FLBlocks.QUAD_PLANTER);
        FLCreativeTabs.accept(out, FLBlocks.HYDROPONIC_PLANTER);
        FLCreativeTabs.accept(out, FLBlocks.BONSAI_PLANTER);
        FLCreativeTabs.accept(out, FLBlocks.HANGING_PLANTER);
        FLCreativeTabs.accept(out, FLBlocks.TRELLIS_PLANTER);
        FLCreativeTabs.accept(out, FLBlocks.PICKER);
        FLCreativeTabs.accept(out, FLBlocks.SWEEPER);
        FLCreativeTabs.accept(out, FLBlocks.GRAPE_TRELLIS_POST);
        FLCreativeTabs.accept(out, FLBlocks.SEALED_BRICKS);
        FLCreativeTabs.accept(out, FLBlocks.CHISELED_SEALED_BRICKS);
        FLCreativeTabs.accept(out, FLBlocks.POLISHED_SEALED_BRICKS);
        FLCreativeTabs.accept(out, FLBlocks.DARK_LADDER);
        FLCreativeTabs.accept(out, FLBlocks.SEALED_DOOR);
        FLCreativeTabs.accept(out, FLBlocks.SEALED_WALL);
        FLCreativeTabs.accept(out, FLBlocks.SEALED_TRAPDOOR);
        FLCreativeTabs.accept(out, FLItems.HOLLOW_SHELL);
        FLCreativeTabs.accept(out, FLItems.WINE_GLASS);
        FLCreativeTabs.accept(out, FLItems.TREATED_LUMBER);
        FLCreativeTabs.accept(out, FLBlocks.TREATED_WOOD);
        for (OvenType ovenType : Wood.values()) {
            FLCreativeTabs.accept(out, FLBlocks.FOOD_SHELVES, ovenType);
            FLCreativeTabs.accept(out, FLBlocks.HANGERS, ovenType);
            FLCreativeTabs.accept(out, FLBlocks.JARBNETS, ovenType);
            FLCreativeTabs.accept(out, FLBlocks.BIG_BARRELS, ovenType);
            FLCreativeTabs.accept(out, FLBlocks.STOMPING_BARRELS, ovenType);
            FLCreativeTabs.accept(out, FLBlocks.BARREL_PRESSES, ovenType);
            FLCreativeTabs.accept(out, FLBlocks.WINE_SHELVES, ovenType);
        }
        for (Enum enum_ : Carving.values()) {
            FLCreativeTabs.accept(out, FLBlocks.CARVED_PUMPKINS, enum_);
            FLCreativeTabs.accept(out, FLBlocks.JACK_O_LANTERNS, enum_);
        }
        FLCreativeTabs.accept(out, FLItems.REINFORCED_GLASS);
        FLCreativeTabs.accept(out, FLBlocks.COPPER_PIPE);
        FLCreativeTabs.accept(out, FLBlocks.OXIDIZED_COPPER_PIPE);
        FLCreativeTabs.accept(out, FLBlocks.IRRIGATION_TANK);
        FLCreativeTabs.accept(out, FLBlocks.PUMPING_STATION);
        FLCreativeTabs.accept(out, FLItems.SPRINKLER);
        for (Enum enum_ : Greenhouse.values()) {
            for (Greenhouse.BlockType blockType : Greenhouse.BlockType.values()) {
                FLCreativeTabs.accept(out, FLBlocks.GREENHOUSE_BLOCKS, enum_, blockType);
            }
        }
    }

    public static void onBuildCreativeTab(BuildCreativeModeTabContentsEvent out) {
        if (out.getTab() == TFCCreativeTabs.FOOD.tab().get()) {
            FLItems.FOODS.values().forEach(reg -> FLCreativeTabs.accept((CreativeModeTab.Output)out, reg));
            FLItems.FRUITS.values().forEach(reg -> FLCreativeTabs.accept((CreativeModeTab.Output)out, reg));
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLItems.FILLED_PIE);
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLItems.RAW_PIZZA);
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLItems.STINKY_SOUP);
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLItems.NIGHTSHADE_BERRY);
            FLItems.FL_FRUIT_PRESERVES.values().forEach(reg -> FLCreativeTabs.accept((CreativeModeTab.Output)out, reg));
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.CHEDDAR_WHEEL);
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.CHEVRE_WHEEL);
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.RAJYA_METOK_WHEEL);
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.GOUDA_WHEEL);
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.FETA_WHEEL);
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.SHOSHA_WHEEL);
        } else if (out.getTab() == TFCCreativeTabs.METAL.tab().get()) {
            for (FLMetal metal : FLMetal.values()) {
                for (FLMetal.ItemType itemType : FLMetal.ItemType.values()) {
                    FLCreativeTabs.accept((CreativeModeTab.Output)out, FLItems.METAL_ITEMS, metal, itemType);
                }
                for (FLMetal.ItemType itemType : Metal.BlockType.values()) {
                    FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.METALS, metal, itemType);
                }
            }
        } else if (out.getTab() == TFCCreativeTabs.FLORA.tab().get()) {
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.BUTTERFLY_GRASS);
            FLBlocks.HERBS.values().forEach(reg -> FLCreativeTabs.accept((CreativeModeTab.Output)out, reg));
            for (FLFruitBlocks.Tree tree : FLFruitBlocks.Tree.values()) {
                FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.FRUIT_TREE_SAPLINGS, tree);
                FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.FRUIT_TREE_LEAVES, tree);
            }
            FLBlocks.STATIONARY_BUSHES.values().forEach(reg -> FLCreativeTabs.accept((CreativeModeTab.Output)out, reg));
        } else if (out.getTab() == TFCCreativeTabs.WOOD.tab().get()) {
            for (Wood wood : Wood.values()) {
                FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.FOOD_SHELVES, wood);
                FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.HANGERS, wood);
                FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.JARBNETS, wood);
            }
        } else if (out.getTab() == TFCCreativeTabs.ORES.tab().get()) {
            FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.SMALL_CHROMITE);
            FLItems.CHROMIUM_ORES.values().forEach(reg -> FLCreativeTabs.accept((CreativeModeTab.Output)out, reg));
            for (Rock rock : Rock.values()) {
                for (Ore.Grade grade : Ore.Grade.values()) {
                    FLCreativeTabs.accept((CreativeModeTab.Output)out, FLBlocks.CHROMITE_ORES, rock, grade);
                }
            }
        } else if (out.getTab() == TFCCreativeTabs.MISC.tab().get()) {
            FLItems.METAL_FLUID_BUCKETS.values().forEach(reg -> FLCreativeTabs.accept((CreativeModeTab.Output)out, reg));
            FLItems.EXTRA_FLUID_BUCKETS.values().forEach(reg -> FLCreativeTabs.accept((CreativeModeTab.Output)out, reg));
            FLItems.WINE_FLUID_BUCKETS.values().forEach(reg -> FLCreativeTabs.accept((CreativeModeTab.Output)out, reg));
        }
    }

    private static RegistryObject<CreativeModeTab> register(String name, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator displayItems) {
        return CREATIVE_TABS.register(name, () -> CreativeModeTab.builder().m_257737_(icon).m_257941_((Component)Component.m_237115_((String)("firmalife.creative_tab." + name))).m_257501_(displayItems).m_257652_());
    }

    private static <T extends ItemLike, R extends Supplier<T>, K1, K2> void accept(CreativeModeTab.Output out, Map<K1, Map<K2, R>> map, K1 key1, K2 key2) {
        if (map.containsKey(key1) && map.get(key1).containsKey(key2)) {
            out.m_246326_((ItemLike)((Supplier)map.get(key1).get(key2)).get());
        }
    }

    private static <T extends ItemLike, R extends Supplier<T>, K> void accept(CreativeModeTab.Output out, Map<K, R> map, K key) {
        if (map.containsKey(key)) {
            out.m_246326_((ItemLike)((Supplier)map.get(key)).get());
        }
    }

    private static <T extends ItemLike, R extends Supplier<T>> void accept(CreativeModeTab.Output out, R reg) {
        if (((ItemLike)reg.get()).m_5456_() == Items.f_41852_) {
            FirmaLife.LOGGER.error("BlockItem with no Item added to creative tab: " + String.valueOf(reg));
            FLSelfTests.reportExternalError();
            return;
        }
        out.m_246326_((ItemLike)reg.get());
    }

    private static void accept(CreativeModeTab.Output out, DecorationBlockRegistryObject decoration) {
        out.m_246326_((ItemLike)decoration.stair().get());
        out.m_246326_((ItemLike)decoration.slab().get());
        out.m_246326_((ItemLike)decoration.wall().get());
    }

    private static <T> void consumeOurs(IForgeRegistry<T> registry, Consumer<T> consumer) {
        for (Object value : registry) {
            if (!Objects.requireNonNull(registry.getKey(value)).m_135827_().equals("firmalife")) continue;
            consumer.accept(value);
        }
    }
}

