/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.model;

import com.eerussianguy.firmalife.client.model.SimpleDynamicBlockModel;
import com.eerussianguy.firmalife.common.blockentities.BonsaiPlanterBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.util.Plantable;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class BonsaiPlanterBlockModel
extends SimpleDynamicBlockModel<BonsaiPlanterBlockEntity> {
    private static final int FRUITING_ID = 0;
    private static final int DRY_ID = 1;
    private static final int FLOWERING_ID = 2;
    private static final int BRANCH_ID = 3;
    private static final int LEAVES_ID = 4;

    public BonsaiPlanterBlockModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, ItemOverrides overrides, BakedModel baseModel) {
        super(isAmbientOcclusion, isGui3d, isSideLit, overrides, baseModel);
    }

    @Override
    public void render(BonsaiPlanterBlockEntity planter, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        Plantable plant = planter.getPlantable(0);
        if (plant == null) {
            return;
        }
        boolean water = planter.getWater() > 0.0f;
        float growth = planter.getGrowth(0);
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        int id = 4;
        if (growth >= 1.0f) {
            id = 0;
        } else if (!water) {
            id = 1;
        } else if (growth > 0.66f) {
            id = 2;
        }
        TextureAtlasSprite branch = (TextureAtlasSprite)atlas.apply(plant.getTexture(3));
        TextureAtlasSprite leaves = (TextureAtlasSprite)atlas.apply(plant.getTexture(id));
        poseStack.m_85836_();
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)branch, (int)packedLight, (int)packedOverlay, (float)0.4375f, (float)0.4375f, (float)0.4375f, (float)0.5625f, (float)1.125f, (float)0.5625f);
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)branch, (int)packedLight, (int)packedOverlay, (float)0.4375f, (float)0.75f, (float)0.25f, (float)0.5625f, (float)0.875f, (float)0.4375f);
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)branch, (int)packedLight, (int)packedOverlay, (float)0.3125f, (float)0.875f, (float)0.5f, (float)0.4375f, (float)1.0f, (float)0.75f);
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)leaves, (int)packedLight, (int)packedOverlay, (float)0.25f, (float)0.75f, (float)0.625f, (float)0.625f, (float)1.1875f, (float)1.0f);
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)leaves, (int)packedLight, (int)packedOverlay, (float)0.1875f, (float)0.6875f, (float)0.3125f, (float)0.6875f, (float)1.3125f, (float)0.6875f);
        RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)leaves, (int)packedLight, (int)packedOverlay, (float)0.25f, (float)0.625f, (float)0.0625f, (float)0.75f, (float)1.0625f, (float)0.4375f);
        poseStack.m_85849_();
    }

    @Override
    public BlockEntityType<BonsaiPlanterBlockEntity> type() {
        return (BlockEntityType)FLBlockEntities.BONSAI_PLANTER.get();
    }
}

