/*
 * Decompiled with CFR 0.152.
 */
package mod.trasiter101.esc.common.menu;

import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Contract;

public abstract class ExtendedSlotCapacityMenu
extends AbstractContainerMenu {
    protected final int containerSlots;

    @Contract(pure=true)
    protected ExtendedSlotCapacityMenu(MenuType<? extends ExtendedSlotCapacityMenu> menuType, int windowId, int containerSlots) {
        super(menuType, windowId);
        this.containerSlots = containerSlots;
    }

    protected static ItemStack quickMoveStack(ExtendedSlotCapacityMenu menu, int slotIndex) {
        Slot slot = (Slot)menu.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            if (slotIndex < menu.containerSlots ? !menu.m_38903_(slotStack, menu.containerSlots, menu.f_38839_.size(), true) : !menu.m_38903_(slotStack, 0, menu.containerSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            return slotStack;
        }
        return ItemStack.f_41583_;
    }

    public abstract ItemStack m_7648_(Player var1, int var2);

    public void m_150399_(int slotIndex, int mouseButton, ClickType clickType, Player player) {
        if (0 > slotIndex) {
            ClickAction clickAction;
            if (slotIndex != -999) {
                return;
            }
            if (clickType != ClickType.PICKUP && clickType != ClickType.QUICK_MOVE) {
                return;
            }
            if (mouseButton != 0 && mouseButton != 1) {
                return;
            }
            if (this.m_142621_().m_41619_()) {
                return;
            }
            ClickAction clickAction2 = clickAction = mouseButton == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
            if (clickAction != ClickAction.PRIMARY) {
                player.m_36176_(this.m_142621_().m_41620_(1), true);
                return;
            }
            player.m_36176_(this.m_142621_(), true);
            this.m_142503_(ItemStack.f_41583_);
            return;
        }
        Inventory inventory = player.m_150109_();
        if (mouseButton == 0 || mouseButton == 1) {
            if (clickType == ClickType.PICKUP) {
                this.clickPickup(slotIndex, mouseButton, player);
                return;
            }
            if (clickType == ClickType.QUICK_MOVE) {
                this.clickQuickMove(slotIndex, player);
                return;
            }
        }
        if (clickType == ClickType.SWAP) {
            this.clickSwap(slotIndex, mouseButton, player, inventory);
            return;
        }
        if (clickType == ClickType.CLONE && player.m_150110_().f_35937_ && this.m_142621_().m_41619_()) {
            Slot slot = (Slot)this.f_38839_.get(slotIndex);
            if (slot.m_6657_()) {
                ItemStack slotStack = slot.m_7993_();
                this.m_142503_(slotStack.m_255036_(slotStack.m_41741_()));
            }
            return;
        }
        if (clickType == ClickType.THROW && this.m_142621_().m_41619_()) {
            Slot slot = (Slot)this.f_38839_.get(slotIndex);
            int stackCount = mouseButton == 0 ? 1 : slot.m_7993_().m_41741_();
            ItemStack dropStack = slot.m_150647_(stackCount, Integer.MAX_VALUE, player);
            player.m_36176_(dropStack, true);
            return;
        }
        if (clickType == ClickType.PICKUP_ALL) {
            this.clickPickupAll(slotIndex, mouseButton, player);
        }
    }

    public abstract boolean m_6875_(Player var1);

    protected boolean m_38903_(ItemStack movedStack, int startIndex, int endIndex, boolean reverseDirection) {
        Slot slot;
        int slotIndex;
        boolean haveMovedStack = false;
        int n = slotIndex = reverseDirection ? endIndex - 1 : startIndex;
        if (movedStack.m_41753_()) {
            while (!movedStack.m_41619_() && !(!reverseDirection ? slotIndex >= endIndex : slotIndex < startIndex)) {
                int total;
                slot = (Slot)this.f_38839_.get(slotIndex);
                ItemStack slotStack = slot.m_7993_();
                if (!ItemStack.m_150942_((ItemStack)movedStack, (ItemStack)slotStack)) {
                    slotIndex += reverseDirection ? -1 : 1;
                    continue;
                }
                int maxSize = slotIndex < this.containerSlots ? slot.m_6641_() : Math.min(slot.m_6641_(), movedStack.m_41741_());
                if (maxSize >= (total = slotStack.m_41613_() + movedStack.m_41613_())) {
                    movedStack.m_41764_(0);
                    slotStack.m_41764_(total);
                    slot.m_6654_();
                    haveMovedStack = true;
                    slotIndex += reverseDirection ? -1 : 1;
                    continue;
                }
                if (maxSize > slotStack.m_41613_()) {
                    movedStack.m_41774_(maxSize - slotStack.m_41613_());
                    slotStack.m_41769_(maxSize - slotStack.m_41613_());
                    slot.m_6654_();
                    haveMovedStack = true;
                    slotIndex += reverseDirection ? -1 : 1;
                    continue;
                }
                slotIndex += reverseDirection ? -1 : 1;
            }
        }
        if (!movedStack.m_41619_()) {
            slotIndex = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? slotIndex >= endIndex : slotIndex < startIndex)) {
                slot = (Slot)this.f_38839_.get(slotIndex);
                if (slot.m_6657_() || !slot.m_5857_(movedStack)) {
                    slotIndex += reverseDirection ? -1 : 1;
                    continue;
                }
                if (slotIndex < this.containerSlots) {
                    slot.m_269060_(movedStack.m_41620_(slot.m_6641_()));
                    haveMovedStack = true;
                    slotIndex += reverseDirection ? -1 : 1;
                    continue;
                }
                int splitSize = Math.min(slot.m_5866_(movedStack), movedStack.m_41741_());
                if (movedStack.m_41613_() > splitSize) {
                    slot.m_269060_(movedStack.m_41620_(splitSize));
                    haveMovedStack = true;
                    slotIndex += reverseDirection ? -1 : 1;
                    continue;
                }
                slot.m_269060_(movedStack.m_41620_(movedStack.m_41613_()));
                haveMovedStack = true;
                slotIndex += reverseDirection ? -1 : 1;
            }
        }
        return haveMovedStack;
    }

    protected void clickPickup(int slotIndex, int mouseButton, Player player) {
        ClickAction clickAction = mouseButton == 0 ? ClickAction.PRIMARY : ClickAction.SECONDARY;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        ItemStack slotStack = slot.m_7993_();
        ItemStack carriedStack = this.m_142621_();
        player.m_141945_(carriedStack, slotStack, clickAction);
        if (this.m_246200_(player, clickAction, slot, slotStack, carriedStack)) {
            return;
        }
        if (ForgeHooks.onItemStackedOn((ItemStack)slotStack, (ItemStack)carriedStack, (Slot)slot, (ClickAction)clickAction, (Player)player, (SlotAccess)this.m_150446_())) {
            return;
        }
        if (slotStack.m_41619_()) {
            if (carriedStack.m_41619_()) {
                return;
            }
            int insertCount = clickAction == ClickAction.PRIMARY ? carriedStack.m_41613_() : 1;
            this.m_142503_(slot.m_150656_(carriedStack, insertCount));
            slot.m_6654_();
            return;
        }
        if (!slot.m_8010_(player)) {
            return;
        }
        if (carriedStack.m_41619_()) {
            int extractAmount = clickAction == ClickAction.PRIMARY ? slotStack.m_41613_() : (Math.min(slotStack.m_41613_(), slotStack.m_41741_()) + 1) / 2;
            slot.m_150641_(extractAmount, Integer.MAX_VALUE, player).ifPresent(stack -> {
                this.m_142503_((ItemStack)stack);
                slot.m_142406_(player, stack);
            });
            slot.m_6654_();
            return;
        }
        if (slot.m_5857_(carriedStack)) {
            if (ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)carriedStack)) {
                int insertAmount = clickAction == ClickAction.PRIMARY ? carriedStack.m_41613_() : 1;
                this.m_142503_(slot.m_150656_(carriedStack, insertAmount));
                slot.m_6654_();
                return;
            }
            if (carriedStack.m_41613_() <= slot.m_5866_(carriedStack)) {
                this.m_142503_(slotStack);
                slot.m_269060_(carriedStack);
                slot.m_6654_();
                return;
            }
        }
        if (ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)carriedStack)) {
            slot.m_150641_(slotStack.m_41613_(), carriedStack.m_41741_() - carriedStack.m_41613_(), player).ifPresent(removedStack -> {
                carriedStack.m_41769_(removedStack.m_41613_());
                slot.m_142406_(player, removedStack);
            });
        }
        slot.m_6654_();
    }

    protected void clickQuickMove(int slotIndex, Player player) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_8010_(player)) {
            return;
        }
        ItemStack moveStack = this.m_7648_(player, slotIndex);
        while (!moveStack.m_41619_() && ItemStack.m_41656_((ItemStack)slot.m_7993_(), (ItemStack)moveStack)) {
            moveStack = this.m_7648_(player, slotIndex);
        }
    }

    protected void clickSwap(int slotIndex, int mouseButton, Player player, Inventory inventory) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        ItemStack itemStack = inventory.m_8020_(mouseButton);
        ItemStack slotStack = slot.m_7993_();
        if (itemStack.m_41619_() && slotStack.m_41619_()) {
            return;
        }
        if (itemStack.m_41619_()) {
            if (!slot.m_8010_(player)) {
                return;
            }
            inventory.m_6836_(mouseButton, slotStack);
            slot.m_269060_(ItemStack.f_41583_);
            slot.m_142406_(player, slotStack);
            return;
        }
        if (slotStack.m_41619_()) {
            if (!slot.m_5857_(itemStack)) {
                return;
            }
            int maxStackSize = slot.m_5866_(itemStack);
            if (maxStackSize >= itemStack.m_41613_()) {
                inventory.m_6836_(mouseButton, ItemStack.f_41583_);
                slot.m_269060_(itemStack);
                return;
            }
            slot.m_269060_(itemStack.m_41620_(maxStackSize));
            return;
        }
        if (slot.m_8010_(player) && slot.m_5857_(itemStack)) {
            int maxStackSize = slot.m_5866_(itemStack);
            if (itemStack.m_41613_() <= maxStackSize) {
                inventory.m_6836_(mouseButton, slotStack);
                slot.m_269060_(itemStack);
                slot.m_142406_(player, slotStack);
                return;
            }
            slot.m_269060_(itemStack.m_41620_(maxStackSize));
            slot.m_142406_(player, slotStack);
            if (!inventory.m_36054_(slotStack)) {
                player.m_36176_(slotStack, true);
            }
        }
    }

    protected void clickPickupAll(int slotIndex, int mouseButton, Player player) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        ItemStack carriedStack = this.m_142621_();
        if (!(carriedStack.m_41619_() || slot.m_6657_() && slot.m_8010_(player))) {
            int l1 = mouseButton == 0 ? 0 : this.f_38839_.size() - 1;
            int k2 = mouseButton == 0 ? 1 : -1;
            for (int l2 = 0; l2 < 2; ++l2) {
                for (int l3 = l1; l3 >= 0 && l3 < this.f_38839_.size() && carriedStack.m_41613_() < carriedStack.m_41741_(); l3 += k2) {
                    Slot loopSlot = (Slot)this.f_38839_.get(l3);
                    if (!loopSlot.m_6657_() || !ExtendedSlotCapacityMenu.m_38899_((Slot)loopSlot, (ItemStack)carriedStack, (boolean)true) || !loopSlot.m_8010_(player) || !this.m_5882_(carriedStack, loopSlot)) continue;
                    ItemStack loopStack = loopSlot.m_7993_();
                    if (l2 == 0 && loopStack.m_41613_() == loopStack.m_41741_()) continue;
                    ItemStack resultStack = loopSlot.m_150647_(loopStack.m_41613_(), carriedStack.m_41741_() - carriedStack.m_41613_(), player);
                    carriedStack.m_41769_(resultStack.m_41613_());
                }
            }
        }
    }

    protected final boolean m_246200_(Player player, ClickAction clickAction, Slot slot, ItemStack clickedStack, ItemStack carriedStack) {
        FeatureFlagSet featureflagset = player.m_9236_().m_246046_();
        if (carriedStack.m_246617_(featureflagset) && carriedStack.m_150926_(slot, clickAction, player)) {
            return true;
        }
        return clickedStack.m_246617_(featureflagset) && clickedStack.m_150932_(carriedStack, slot, clickAction, player, this.m_150446_());
    }

    @Contract(value="-> new", pure=true)
    protected final SlotAccess m_150446_() {
        return new SlotAccess(){

            public ItemStack m_142196_() {
                return ExtendedSlotCapacityMenu.this.m_142621_();
            }

            public boolean m_142104_(ItemStack itemStack) {
                ExtendedSlotCapacityMenu.this.m_142503_(itemStack);
                return true;
            }
        };
    }
}

