/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.sql.dto.IBaseDTO;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.Logger;

public class DatabaseUpdater {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final String SCHEMA_TABLE_NAME = "Schema";
    public static final String UPDATE_SCRIPT_BATCH_SEPARATOR = "--batch--";
    public static final String UPDATE_SCRIPT_NO_TRANSACTION_FLAG = "--No Transactions--";
    private static final String SQL_SCRIPT_RESOURCE_FOLDER = "sqlScripts/";
    private static final String SQL_SCRIPT_LIST_FILE = "sqlScripts/scriptList.txt";

    public static <TKey, TDTO extends IBaseDTO<TKey>> void runAutoUpdateScripts(AbstractDhRepo<TKey, TDTO> repo) throws SQLException {
        ArrayList<SqlScript> scriptList;
        try {
            scriptList = DatabaseUpdater.getAutoUpdateScripts();
        }
        catch (IOException e) {
            LOGGER.error("Get auto update SQL scripts failed. Error: " + e.getMessage(), (Throwable)e);
            return;
        }
        Map<String, Object> schemaTableExistsResult = repo.queryDictionaryFirst("SELECT COUNT(name) as 'tableCount' FROM sqlite_master WHERE type='table' AND name='Schema';");
        if (schemaTableExistsResult == null || (Integer)schemaTableExistsResult.get("tableCount") == 0) {
            String createBaseSchemaTable = "CREATE TABLE Schema ( \n    SchemaVersionId INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \n    ScriptName TEXT NOT NULL UNIQUE, \n    AppliedDateTime DATETIME NOT NULL default CURRENT_TIMESTAMP \n)";
            repo.queryDictionaryFirst(createBaseSchemaTable);
        }
        for (SqlScript resource : scriptList) {
            Map<String, Object> scriptAlreadyRunResult = repo.queryDictionaryFirst("SELECT EXISTS(SELECT 1 FROM Schema WHERE ScriptName='" + resource.name + "') as 'existingCount';");
            if (scriptAlreadyRunResult == null || (Integer)scriptAlreadyRunResult.get("existingCount") != 0) continue;
            LOGGER.info("Running SQL update script: [" + resource.name + "], for repo: [" + repo.databaseFile + "]");
            int sqlIndex = 0;
            try {
                String[] fileUpdateSqlArray = resource.queryString.split(UPDATE_SCRIPT_BATCH_SEPARATOR);
                boolean transactScript = !resource.queryString.contains(UPDATE_SCRIPT_NO_TRANSACTION_FLAG);
                Connection connection = repo.getConnection();
                connection.setAutoCommit(!transactScript);
                try (Statement statement = connection.createStatement();){
                    statement.setQueryTimeout(0);
                    for (String updateSql : fileUpdateSqlArray) {
                        statement.execute(updateSql);
                    }
                    if (transactScript) {
                        connection.commit();
                    }
                }
                catch (SQLException e) {
                    connection.rollback();
                    LOGGER.error("Unexpected SQL Error: [" + e.getMessage() + "] returned for auto update script: [" + resource.name + "], query: [" + fileUpdateSqlArray[sqlIndex] + "]. Changes should have been rolled back.", (Throwable)new SQLException());
                    throw e;
                }
                if (transactScript) {
                    connection.setAutoCommit(true);
                }
            }
            catch (RuntimeException e) {
                LOGGER.error("Unexpected error running database update script [" + resource.name + "] on database [" + repo.databaseFile + "], stopping database update. Database reading/writing may fail if you continue. \nError: [" + e.getMessage() + "]. \nSql Script:[" + resource.queryString + "]", (Throwable)e);
                throw e;
            }
            repo.queryDictionaryFirst("INSERT INTO Schema (ScriptName) VALUES('" + resource.name + "');");
        }
    }

    private static ArrayList<SqlScript> getAutoUpdateScripts() throws NullPointerException, IOException {
        String[] sqlScriptNames;
        String scriptListString;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try (InputStream scriptListInputStream = loader.getResourceAsStream(SQL_SCRIPT_LIST_FILE);){
            if (scriptListInputStream == null) {
                throw new NullPointerException("Failed to find the SQL Script list file [sqlScripts/scriptList.txt], no auto update scripts can be run.");
            }
            try (Scanner scanner = new Scanner(scriptListInputStream).useDelimiter("\\A");){
                scriptListString = scanner.hasNext() ? scanner.next() : "";
            }
        }
        ArrayList<SqlScript> scriptList = new ArrayList<SqlScript>();
        for (String scriptName : sqlScriptNames = scriptListString.split("\n")) {
            if ((scriptName = scriptName.trim()).isEmpty()) continue;
            scriptName = SQL_SCRIPT_RESOURCE_FOLDER + scriptName.trim();
            try (InputStream scriptInputStream = loader.getResourceAsStream(scriptName);){
                if (scriptInputStream == null) {
                    throw new NullPointerException("Failed to find the SQL Script file [" + scriptName + "], no auto update scripts can be run.");
                }
                try (Scanner fileScanner = new Scanner(scriptInputStream).useDelimiter("\\A");){
                    scriptListString = fileScanner.hasNext() ? fileScanner.next() : "";
                }
                scriptList.add(new SqlScript(scriptName, scriptListString));
            }
        }
        return scriptList;
    }

    public static int getAutoUpdateScriptCount() throws NullPointerException, IOException {
        return DatabaseUpdater.getAutoUpdateScripts().size();
    }

    private static class SqlScript {
        public String name;
        public String queryString;

        public SqlScript(String name, String queryString) {
            this.name = name;
            this.queryString = queryString;
        }
    }
}

