/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.vertexFormat;

import com.google.common.collect.ImmutableList;
import com.seibel.distanthorizons.core.render.vertexFormat.LodVertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.stream.Collectors;

public class LodVertexFormat {
    private final ImmutableList<LodVertexFormatElement> elements;
    private final IntList offsets = new IntArrayList();
    private final int byteSize;

    public LodVertexFormat(ImmutableList<LodVertexFormatElement> elementList) {
        this.elements = elementList;
        int i = 0;
        for (LodVertexFormatElement LodVertexFormatElement2 : elementList) {
            this.offsets.add(i);
            i += LodVertexFormatElement2.getByteSize();
        }
        this.byteSize = i;
    }

    public int getByteSize() {
        return this.byteSize;
    }

    public ImmutableList<LodVertexFormatElement> getElements() {
        return this.elements;
    }

    public int getOffset(int index) {
        return this.offsets.getInt(index);
    }

    public String toString() {
        return "format: " + this.elements.size() + " elements: " + this.elements.stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            LodVertexFormat vertexFormat = (LodVertexFormat)obj;
            return this.byteSize == vertexFormat.byteSize && this.elements.equals(vertexFormat.elements);
        }
        return false;
    }

    public int hashCode() {
        return this.elements.hashCode();
    }
}

