/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.glObject.GLState;
import com.seibel.distanthorizons.core.render.renderer.shaders.FogApplyShader;
import com.seibel.distanthorizons.core.render.renderer.shaders.FogShader;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL32;

public class FogRenderer {
    public static FogRenderer INSTANCE = new FogRenderer();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private boolean init = false;
    private int width = -1;
    private int height = -1;
    private int fogFramebuffer = -1;
    private int fogTexture = -1;

    private FogRenderer() {
    }

    public void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        FogShader.INSTANCE.init();
        FogApplyShader.INSTANCE.init();
    }

    private void createFramebuffer(int width, int height) {
        if (this.fogFramebuffer != -1) {
            GL32.glDeleteFramebuffers((int)this.fogFramebuffer);
            this.fogFramebuffer = -1;
        }
        if (this.fogTexture != -1) {
            GL32.glDeleteTextures((int)this.fogTexture);
            this.fogTexture = -1;
        }
        this.fogFramebuffer = GL32.glGenFramebuffers();
        GL32.glBindFramebuffer((int)36160, (int)this.fogFramebuffer);
        this.fogTexture = GL32.glGenTextures();
        GL32.glBindTexture((int)3553, (int)this.fogTexture);
        GL32.glTexImage2D((int)3553, (int)0, (int)32859, (int)width, (int)height, (int)0, (int)6408, (int)32819, (ByteBuffer)null);
        GL32.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL32.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL32.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.fogTexture, (int)0);
    }

    public void render(GLState primaryState, Mat4f projectionMatrix, float partialTicks) {
        GLState state = new GLState();
        this.init();
        int width = MC_RENDER.getTargetFrameBufferViewportWidth();
        int height = MC_RENDER.getTargetFrameBufferViewportHeight();
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            this.createFramebuffer(width, height);
        }
        FogShader.INSTANCE.frameBuffer = this.fogFramebuffer;
        FogShader.INSTANCE.setProjectionMatrix(projectionMatrix);
        FogShader.INSTANCE.render(partialTicks);
        primaryState.restore();
        FogApplyShader.INSTANCE.fogTexture = this.fogTexture;
        FogApplyShader.INSTANCE.render(partialTicks);
        state.restore();
    }

    public void free() {
        FogShader.INSTANCE.free();
        FogApplyShader.INSTANCE.free();
    }
}

