/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.seibel.distanthorizons.api.interfaces.render.IDhApiRenderProxy;
import com.seibel.distanthorizons.api.objects.DhApiResult;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.util.RenderUtil;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;

public class DhApiRenderProxy
implements IDhApiRenderProxy {
    public static final DhApiRenderProxy INSTANCE = new DhApiRenderProxy();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private boolean deferTransparentRendering = false;

    private DhApiRenderProxy() {
    }

    @Override
    public DhApiResult<Boolean> clearRenderDataCache() {
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        if (world == null) {
            return DhApiResult.createFail("No world loaded");
        }
        Iterable<? extends IDhLevel> loadedLevels = world.getAllLoadedLevels();
        for (IDhLevel iDhLevel : loadedLevels) {
            if (!(iDhLevel instanceof IDhClientLevel)) continue;
            ((IDhClientLevel)iDhLevel).clearRenderCache();
        }
        return DhApiResult.createSuccess();
    }

    @Override
    public DhApiResult<Integer> getDhDepthTextureId() {
        int activeTexture = LodRenderer.getActiveDepthTextureId();
        return activeTexture == -1 ? DhApiResult.createFail("DH's depth texture hasn't been created and/or bound yet.", -1) : DhApiResult.createSuccess(activeTexture);
    }

    @Override
    public DhApiResult<Integer> getDhColorTextureId() {
        int activeTexture = LodRenderer.getActiveColorTextureId();
        return activeTexture == -1 ? DhApiResult.createFail("DH's color texture hasn't been created and/or bound yet.", -1) : DhApiResult.createSuccess(activeTexture);
    }

    @Override
    public void setDeferTransparentRendering(boolean deferTransparentRendering) {
        this.deferTransparentRendering = deferTransparentRendering;
    }

    @Override
    public boolean getDeferTransparentRendering() {
        return this.deferTransparentRendering;
    }

    @Override
    public float getNearClipPlaneDistanceInBlocks(float partialTicks) {
        return RenderUtil.getNearClipPlaneDistanceInBlocks(partialTicks);
    }
}

