/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.core.file.fullDatafile.GeneratedFullDataSourceProvider;
import com.seibel.distanthorizons.core.generation.IFullDataSourceRetrievalQueue;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;

public class WorldGenModule
implements Closeable {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private final GeneratedFullDataSourceProvider.IOnWorldGenCompleteListener onWorldGenCompleteListener;
    private final AtomicReference<AbstractWorldGenState> worldGenStateRef = new AtomicReference();

    public WorldGenModule(GeneratedFullDataSourceProvider.IOnWorldGenCompleteListener onWorldGenCompleteListener) {
        this.onWorldGenCompleteListener = onWorldGenCompleteListener;
    }

    public void startWorldGen(GeneratedFullDataSourceProvider dataFileHandler, AbstractWorldGenState newWgs) {
        if (!this.worldGenStateRef.compareAndSet(null, newWgs)) {
            LOGGER.warn("Failed to start world gen due to concurrency");
            newWgs.closeAsync(false);
        }
        dataFileHandler.addWorldGenCompleteListener(this.onWorldGenCompleteListener);
        dataFileHandler.setWorldGenerationQueue(newWgs.worldGenerationQueue);
    }

    public void stopWorldGen(GeneratedFullDataSourceProvider dataFileHandler) {
        AbstractWorldGenState worldGenState = this.worldGenStateRef.get();
        if (worldGenState == null) {
            LOGGER.warn("Attempted to stop world gen when it was not running");
            return;
        }
        while (!this.worldGenStateRef.compareAndSet(worldGenState, null)) {
            worldGenState = this.worldGenStateRef.get();
            if (worldGenState != null) continue;
            return;
        }
        dataFileHandler.clearRetrievalQueue();
        worldGenState.closeAsync(true).join();
        dataFileHandler.removeWorldGenCompleteListener(this.onWorldGenCompleteListener);
    }

    public void worldGenTick(DhBlockPos2D targetPosForGeneration) {
        AbstractWorldGenState worldGenState = this.worldGenStateRef.get();
        if (worldGenState != null) {
            worldGenState.startGenerationQueueAndSetTargetPos(targetPosForGeneration);
        }
    }

    @Override
    public void close() {
        AbstractWorldGenState worldGenState = this.worldGenStateRef.get();
        if (worldGenState != null) {
            while (!this.worldGenStateRef.compareAndSet(worldGenState, null) && (worldGenState = this.worldGenStateRef.get()) != null) {
            }
            if (worldGenState != null) {
                worldGenState.closeAsync(true).join();
            }
        }
    }

    public boolean isWorldGenRunning() {
        return this.worldGenStateRef.get() != null;
    }

    public String getDebugMenuString() {
        AbstractWorldGenState worldGenState = this.worldGenStateRef.get();
        if (worldGenState == null) {
            return null;
        }
        String waitingCountStr = F3Screen.NUMBER_FORMAT.format(worldGenState.worldGenerationQueue.getWaitingTaskCount());
        String inProgressCountStr = F3Screen.NUMBER_FORMAT.format(worldGenState.worldGenerationQueue.getInProgressTaskCount());
        String totalCountEstimateStr = F3Screen.NUMBER_FORMAT.format(worldGenState.worldGenerationQueue.getEstimatedTotalTaskCount());
        return "World Gen Tasks: " + waitingCountStr + "/" + totalCountEstimateStr + " (in progress: " + inProgressCountStr + ")";
    }

    public static abstract class AbstractWorldGenState {
        public IFullDataSourceRetrievalQueue worldGenerationQueue;

        CompletableFuture<Void> closeAsync(boolean doInterrupt) {
            return ((CompletableFuture)((CompletableFuture)this.worldGenerationQueue.startClosing(true, doInterrupt).exceptionally(ex -> {
                LOGGER.error("Error closing generation queue", ex);
                return null;
            })).thenRun(this.worldGenerationQueue::close)).exceptionally(ex -> {
                LOGGER.error("Error closing world gen", ex);
                return null;
            });
        }

        public void startGenerationQueueAndSetTargetPos(DhBlockPos2D targetPosForGeneration) {
            this.worldGenerationQueue.startAndSetTargetPos(targetPosForGeneration);
        }
    }
}

