/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.config.eventHandlers.presets;

import com.seibel.distanthorizons.api.enums.config.quickOptions.EDhApiThreadPreset;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigEntryWithPresetOptions;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.AbstractPresetConfigEventHandler;
import com.seibel.distanthorizons.core.config.listeners.ConfigChangeListener;
import com.seibel.distanthorizons.coreapi.interfaces.config.IConfigEntry;
import com.seibel.distanthorizons.coreapi.util.MathUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadPresetConfigEventHandler
extends AbstractPresetConfigEventHandler<EDhApiThreadPreset> {
    public static final ThreadPresetConfigEventHandler INSTANCE = new ThreadPresetConfigEventHandler();
    private static final Logger LOGGER = LogManager.getLogger();
    private final ConfigEntryWithPresetOptions<EDhApiThreadPreset, Integer> worldGenThreadCount = new ConfigEntryWithPresetOptions<EDhApiThreadPreset, Integer>(Config.Client.Advanced.MultiThreading.numberOfWorldGenerationThreads, new HashMap<EDhApiThreadPreset, Integer>(){
        {
            this.put(EDhApiThreadPreset.MINIMAL_IMPACT, 1);
            this.put(EDhApiThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getWorldGenDefaultThreadCount());
            this.put(EDhApiThreadPreset.BALANCED, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.15));
            this.put(EDhApiThreadPreset.AGGRESSIVE, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.25));
            this.put(EDhApiThreadPreset.I_PAID_FOR_THE_WHOLE_CPU, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.5));
        }
    });
    private final ConfigEntryWithPresetOptions<EDhApiThreadPreset, Double> worldGenRunTime = new ConfigEntryWithPresetOptions<EDhApiThreadPreset, Double>(Config.Client.Advanced.MultiThreading.runTimeRatioForWorldGenerationThreads, new HashMap<EDhApiThreadPreset, Double>(){
        {
            this.put(EDhApiThreadPreset.MINIMAL_IMPACT, 0.1);
            this.put(EDhApiThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getWorldGenDefaultRunTimeRatio());
            this.put(EDhApiThreadPreset.BALANCED, 0.75);
            this.put(EDhApiThreadPreset.AGGRESSIVE, 1.0);
            this.put(EDhApiThreadPreset.I_PAID_FOR_THE_WHOLE_CPU, 1.0);
        }
    });
    private final ConfigEntryWithPresetOptions<EDhApiThreadPreset, Integer> fileHandlerThreadCount = new ConfigEntryWithPresetOptions<EDhApiThreadPreset, Integer>(Config.Client.Advanced.MultiThreading.numberOfFileHandlerThreads, new HashMap<EDhApiThreadPreset, Integer>(){
        {
            this.put(EDhApiThreadPreset.MINIMAL_IMPACT, 1);
            this.put(EDhApiThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getFileHandlerDefaultThreadCount());
            this.put(EDhApiThreadPreset.BALANCED, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.2));
            this.put(EDhApiThreadPreset.AGGRESSIVE, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.2));
            this.put(EDhApiThreadPreset.I_PAID_FOR_THE_WHOLE_CPU, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.5));
        }
    });
    private final ConfigEntryWithPresetOptions<EDhApiThreadPreset, Double> fileHandlerRunTime = new ConfigEntryWithPresetOptions<EDhApiThreadPreset, Double>(Config.Client.Advanced.MultiThreading.runTimeRatioForFileHandlerThreads, new HashMap<EDhApiThreadPreset, Double>(){
        {
            this.put(EDhApiThreadPreset.MINIMAL_IMPACT, 0.25);
            this.put(EDhApiThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getFileHandlerDefaultRunTimeRatio());
            this.put(EDhApiThreadPreset.BALANCED, 1.0);
            this.put(EDhApiThreadPreset.AGGRESSIVE, 1.0);
            this.put(EDhApiThreadPreset.I_PAID_FOR_THE_WHOLE_CPU, 1.0);
        }
    });
    private final ConfigEntryWithPresetOptions<EDhApiThreadPreset, Integer> UpdatePropagatorThreadCount = new ConfigEntryWithPresetOptions<EDhApiThreadPreset, Integer>(Config.Client.Advanced.MultiThreading.numberOfUpdatePropagatorThreads, new HashMap<EDhApiThreadPreset, Integer>(){
        {
            this.put(EDhApiThreadPreset.MINIMAL_IMPACT, 1);
            this.put(EDhApiThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getUpdatePropagatorDefaultThreadCount());
            this.put(EDhApiThreadPreset.BALANCED, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.25));
            this.put(EDhApiThreadPreset.AGGRESSIVE, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.5));
            this.put(EDhApiThreadPreset.I_PAID_FOR_THE_WHOLE_CPU, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.75));
        }
    });
    private final ConfigEntryWithPresetOptions<EDhApiThreadPreset, Double> UpdatePropagatorRunTime = new ConfigEntryWithPresetOptions<EDhApiThreadPreset, Double>(Config.Client.Advanced.MultiThreading.runTimeRatioForUpdatePropagatorThreads, new HashMap<EDhApiThreadPreset, Double>(){
        {
            this.put(EDhApiThreadPreset.MINIMAL_IMPACT, 0.1);
            this.put(EDhApiThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getUpdatePropagatorDefaultRunTimeRatio());
            this.put(EDhApiThreadPreset.BALANCED, 0.5);
            this.put(EDhApiThreadPreset.AGGRESSIVE, 0.75);
            this.put(EDhApiThreadPreset.I_PAID_FOR_THE_WHOLE_CPU, 1.0);
        }
    });
    private final ConfigEntryWithPresetOptions<EDhApiThreadPreset, Integer> lodBuilderThreadCount = new ConfigEntryWithPresetOptions<EDhApiThreadPreset, Integer>(Config.Client.Advanced.MultiThreading.numberOfLodBuilderThreads, new HashMap<EDhApiThreadPreset, Integer>(){
        {
            this.put(EDhApiThreadPreset.MINIMAL_IMPACT, 1);
            this.put(EDhApiThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getLodBuilderDefaultThreadCount());
            this.put(EDhApiThreadPreset.BALANCED, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.2));
            this.put(EDhApiThreadPreset.AGGRESSIVE, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.4));
            this.put(EDhApiThreadPreset.I_PAID_FOR_THE_WHOLE_CPU, ThreadPresetConfigEventHandler.getThreadCountByPercent(0.6));
        }
    });
    private final ConfigEntryWithPresetOptions<EDhApiThreadPreset, Double> lodBuilderRunTime = new ConfigEntryWithPresetOptions<EDhApiThreadPreset, Double>(Config.Client.Advanced.MultiThreading.runTimeRatioForLodBuilderThreads, new HashMap<EDhApiThreadPreset, Double>(){
        {
            this.put(EDhApiThreadPreset.MINIMAL_IMPACT, 0.1);
            this.put(EDhApiThreadPreset.LOW_IMPACT, ThreadPresetConfigEventHandler.getLodBuilderDefaultRunTimeRatio());
            this.put(EDhApiThreadPreset.BALANCED, 0.5);
            this.put(EDhApiThreadPreset.AGGRESSIVE, 0.75);
            this.put(EDhApiThreadPreset.I_PAID_FOR_THE_WHOLE_CPU, 1.0);
        }
    });

    public static int getWorldGenDefaultThreadCount() {
        return ThreadPresetConfigEventHandler.getThreadCountByPercent(0.1);
    }

    public static double getWorldGenDefaultRunTimeRatio() {
        return 0.5;
    }

    public static int getFileHandlerDefaultThreadCount() {
        return ThreadPresetConfigEventHandler.getThreadCountByPercent(0.1);
    }

    public static double getFileHandlerDefaultRunTimeRatio() {
        return 0.5;
    }

    public static int getUpdatePropagatorDefaultThreadCount() {
        return ThreadPresetConfigEventHandler.getThreadCountByPercent(0.1);
    }

    public static double getUpdatePropagatorDefaultRunTimeRatio() {
        return 0.25;
    }

    public static int getLodBuilderDefaultThreadCount() {
        return ThreadPresetConfigEventHandler.getThreadCountByPercent(0.1);
    }

    public static double getLodBuilderDefaultRunTimeRatio() {
        return 0.25;
    }

    private ThreadPresetConfigEventHandler() {
        this.configList.add(this.worldGenThreadCount);
        this.configList.add(this.worldGenRunTime);
        this.configList.add(this.fileHandlerThreadCount);
        this.configList.add(this.fileHandlerRunTime);
        this.configList.add(this.UpdatePropagatorThreadCount);
        this.configList.add(this.UpdatePropagatorRunTime);
        this.configList.add(this.lodBuilderThreadCount);
        this.configList.add(this.lodBuilderRunTime);
        for (ConfigEntryWithPresetOptions config : this.configList) {
            new ConfigChangeListener<Object>(config.configEntry, val -> this.onConfigValueChanged());
        }
    }

    private static int getThreadCountByPercent(double percent) throws IllegalArgumentException {
        if (percent <= 0.0 || percent > 1.0) {
            throw new IllegalArgumentException("percent must be greater than 0 and less than or equal to 1.");
        }
        int totalProcessorCount = Runtime.getRuntime().availableProcessors();
        int coreCount = (int)Math.ceil((double)totalProcessorCount * percent);
        return MathUtil.clamp(1, coreCount, totalProcessorCount);
    }

    @Override
    protected IConfigEntry<EDhApiThreadPreset> getPresetConfigEntry() {
        return Config.Client.threadPresetSetting;
    }

    @Override
    protected List<EDhApiThreadPreset> getPresetEnumList() {
        return Arrays.asList(EDhApiThreadPreset.values());
    }

    @Override
    protected EDhApiThreadPreset getCustomPresetEnum() {
        return EDhApiThreadPreset.CUSTOM;
    }
}

