/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.recipes;

import com.lazrproductions.cuffed.init.ModItems;
import com.lazrproductions.cuffed.init.ModRecipes;
import com.lazrproductions.cuffed.items.BakedKeyMoldItem;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class BakedKeyMoldCopyRecipe
extends CustomRecipe {
    public BakedKeyMoldCopyRecipe(ResourceLocation idIn, CraftingBookCategory category) {
        super(idIn, category);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level level) {
        return this.isGridValid(inv);
    }

    public ItemStack assemble(@Nonnull CraftingContainer inv, @Nonnull RegistryAccess access) {
        if (this.matches(inv, null)) {
            ItemStack moldStack = this.getMoldFromGrid(inv);
            return moldStack.m_41784_().m_128441_("CopiedKey") ? BakedKeyMoldItem.createKeyFrom(moldStack, 1) : ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public ArrayList<ItemStack> getAllMoldsInGrid(@Nonnull CraftingContainer inv) {
        ArrayList<ItemStack> moldsInGrid = new ArrayList<ItemStack>(0);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            Item item;
            ItemStack checkingStack = inv.m_8020_(i);
            if (checkingStack.m_41619_() || !checkingStack.m_150930_((Item)ModItems.BAKED_KEY_MOLD.get()) && !checkingStack.m_150930_(Items.f_42416_) || (item = checkingStack.m_41720_()) != ModItems.BAKED_KEY_MOLD.get() || !checkingStack.m_41784_().m_128441_("CopiedKey")) continue;
            moldsInGrid.add(checkingStack);
        }
        return moldsInGrid;
    }

    public ArrayList<ItemStack> getAllValidItemsInGrid(@Nonnull CraftingContainer inv) {
        ArrayList<ItemStack> validInGrid = new ArrayList<ItemStack>(0);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack checkingStack = inv.m_8020_(i);
            if (checkingStack.m_41619_() || !checkingStack.m_150930_((Item)ModItems.BAKED_KEY_MOLD.get()) && !checkingStack.m_150930_(Items.f_42416_)) continue;
            validInGrid.add(checkingStack);
        }
        return validInGrid;
    }

    public ItemStack getMoldFromGrid(@Nonnull CraftingContainer inv) {
        ArrayList<ItemStack> moldsInGrid = this.getAllMoldsInGrid(inv);
        return moldsInGrid.get(0);
    }

    public boolean isGridValid(@Nonnull CraftingContainer inv) {
        int numofMolds = 0;
        int numOfIngots = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack checkingStack = inv.m_8020_(i);
            if (checkingStack.m_41619_()) continue;
            if (checkingStack.m_150930_((Item)ModItems.BAKED_KEY_MOLD.get()) && checkingStack.m_41784_().m_128441_("CopiedKey")) {
                ++numofMolds;
                continue;
            }
            if (checkingStack.m_150930_(Items.f_42416_)) {
                ++numOfIngots;
                continue;
            }
            return false;
        }
        return numOfIngots == 1 && numofMolds == 1;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.BAKED_KEY_MOLD_COPY.get();
    }

    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer container) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            int oldQuality;
            ItemStack item = container.m_8020_(i);
            if (!item.m_150930_((Item)ModItems.BAKED_KEY_MOLD.get()) || (oldQuality = item.m_41784_().m_128451_("Quality")) <= 1) continue;
            item.m_41784_().m_128405_("Quality", oldQuality - 1);
            nonnulllist.set(i, (Object)item.m_41777_());
        }
        return nonnulllist;
    }
}

