/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.entity;

import com.lazrproductions.cuffed.init.ModEntityTypes;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class CrumblingBlockEntity
extends Entity {
    static int CRUMBLE_STAGE_TIME = 20;
    private BlockState blockState = Blocks.f_49992_.m_49966_();
    public int time = CRUMBLE_STAGE_TIME * 5;
    protected static final EntityDataAccessor<Integer> DATA_CRUMBLE_PROGRESS = SynchedEntityData.m_135353_(CrumblingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public CrumblingBlockEntity(EntityType<? extends CrumblingBlockEntity> type, Level level) {
        super(type, level);
    }

    public CrumblingBlockEntity(Level world, BlockPos pos, BlockState state, int crumbleProgress) {
        super((EntityType)ModEntityTypes.CRUMBLING_BLOCK.get(), world);
        this.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        this.setCrumbleProgress(crumbleProgress, 1);
        this.blockState = state;
        this.time = CRUMBLE_STAGE_TIME * 5;
    }

    public static CrumblingBlockEntity crumbleBlock(Level level, BlockPos pos, BlockState state, int crumbleStrength) {
        if (state.m_280296_()) {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            for (CrumblingBlockEntity e : level.m_45976_(CrumblingBlockEntity.class, new AABB((double)x - 1.0, (double)y - 1.0, (double)z - 1.0, (double)x + 1.0, (double)y + 1.0, (double)z + 1.0))) {
                if (!e.m_20183_().equals((Object)pos) || e.blockState != state) continue;
                e.setCrumbleProgress(e.getCrumbleProgress() + crumbleStrength, 5);
                return e;
            }
            CrumblingBlockEntity e = new CrumblingBlockEntity(level, pos, state, crumbleStrength);
            level.m_7967_((Entity)e);
            return e;
        }
        return null;
    }

    public void setCrumbleProgress(int b, int timeMul) {
        this.f_19804_.m_135381_(DATA_CRUMBLE_PROGRESS, (Object)b);
        this.time = CRUMBLE_STAGE_TIME * timeMul;
    }

    public int getCrumbleProgress() {
        return (Integer)this.f_19804_.m_135370_(DATA_CRUMBLE_PROGRESS);
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_CRUMBLE_PROGRESS, (Object)1);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_8119_() {
        Level l = this.m_9236_();
        if (l.m_8055_(this.m_20183_()).m_60795_()) {
            this.m_146870_();
        } else if (this.getCrumbleProgress() < 5) {
            if (this.getCrumbleProgress() <= 0) {
                this.m_146870_();
            }
        } else {
            l.m_46961_(this.m_20183_(), true);
            this.m_146870_();
        }
    }

    protected void m_7380_(@Nonnull CompoundTag tag) {
        tag.m_128405_("Time", this.time);
        tag.m_128405_("CrumbleProgress", this.getCrumbleProgress());
    }

    protected void m_7378_(@Nonnull CompoundTag tag) {
        this.time = tag.m_128451_("Time");
        this.setCrumbleProgress(tag.m_128451_("CrumbleProgress"), 1);
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6051_() {
        return false;
    }
}

