/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks.entity;

import com.lazrproductions.cuffed.init.ModBlockEntities;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class ToiletBlockEntity
extends BlockEntity {
    private static final int INVENTORY_SIZE = 1;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public ToiletBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TRAY.get(), pos, state);
    }

    public InteractionResult use(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player interacting, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        if (hand == InteractionHand.MAIN_HAND && !level.m_5776_()) {
            ItemStack stack = interacting.m_21120_(hand);
            if (stack.m_41619_()) {
                ItemStack stackToRemove = this.getNextStack();
                if (this.removeNextItem()) {
                    interacting.m_21008_(hand, stackToRemove.m_41777_());
                    level.m_6263_((Player)null, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f), SoundEvents.f_11781_, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
                    this.sendUpdate(level, pos, state);
                    return InteractionResult.CONSUME;
                }
            } else if (this.addItem(stack.m_255036_(1))) {
                stack.m_41774_(1);
                level.m_6263_((Player)null, (double)((float)this.m_58899_().m_123341_() + 0.5f), (double)this.m_58899_().m_123342_(), (double)((float)this.m_58899_().m_123343_() + 0.5f), SoundEvents.f_11778_, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.4f);
                this.sendUpdate(level, pos, state);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.FAIL;
    }

    @Nonnull
    public ItemStack getNextStack() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.m_41619_()) continue;
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    protected boolean addItem(@Nonnull ItemStack stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            this.items.set(i, (Object)stack);
            return true;
        }
        return false;
    }

    protected boolean setItem(@Nonnull ItemStack stack, int index) {
        if (((ItemStack)this.items.get(index)).m_41619_()) {
            this.items.set(index, (Object)stack);
            return true;
        }
        return false;
    }

    protected boolean removeNextItem() {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            return false;
        }
        return this.removeItem(index);
    }

    protected boolean removeItem(int index) {
        if (index >= 0 && index < this.items.size()) {
            boolean removedSomething = !((ItemStack)this.items.get(index)).m_41619_();
            this.items.set(index, (Object)ItemStack.f_41583_);
            return removedSomething;
        }
        return false;
    }

    protected void sendUpdate(Level level, BlockPos pos, BlockState state) {
        ToiletBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    protected void m_183515_(@Nonnull CompoundTag tag) {
        super.m_183515_(tag);
        ListTag list = new ListTag();
        this.items.forEach(c -> {
            CompoundTag t = new CompoundTag();
            c.m_41739_(t);
            list.add((Object)t);
        });
        tag.m_128365_("Items", (Tag)list);
    }

    public void m_142466_(@Nonnull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Items")) {
            ListTag list = tag.m_128437_("Items", 10);
            this.items = NonNullList.m_122780_((int)list.size(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < list.size(); ++i) {
                this.items.set(i, (Object)ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
            }
        }
    }

    public List<ItemStack> getDrops(@Nonnull Level level, @Nonnull BlockPos pos) {
        List<ItemStack> stacks = List.of();
        for (ItemStack itemStack : this.items) {
            stacks.add(itemStack);
        }
        return stacks;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
    }
}

