/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.blocks;

import com.lazrproductions.cuffed.blocks.entity.ToiletBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ToiletBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape SHAPE_NORTH = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.75, (double)1.0, (double)1.125, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.25, (double)0.75), Shapes.m_83048_((double)0.125, (double)0.25, (double)0.125, (double)0.875, (double)0.4375, (double)0.75)});
    protected static final VoxelShape SHAPE_EAST = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.25, (double)1.125, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.25, (double)0.0, (double)0.3125, (double)0.6875, (double)0.25, (double)0.6875), Shapes.m_83048_((double)0.25, (double)0.25, (double)0.125, (double)0.875, (double)0.4375, (double)0.875)});
    protected static final VoxelShape SHAPE_SOUTH = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.125, (double)0.25), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.25, (double)0.6875, (double)0.25, (double)0.6875), Shapes.m_83048_((double)0.125, (double)0.25, (double)0.25, (double)0.875, (double)0.4375, (double)0.875)});
    protected static final VoxelShape SHAPE_WEST = Shapes.m_83124_((VoxelShape)Shapes.m_83048_((double)0.75, (double)0.0, (double)0.0, (double)1.0, (double)1.125, (double)1.0), (VoxelShape[])new VoxelShape[]{Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.75, (double)0.25, (double)0.6875), Shapes.m_83048_((double)0.125, (double)0.25, (double)0.125, (double)0.75, (double)0.4375, (double)0.875)});

    public ToiletBlock(BlockBehaviour.Properties p) {
        super(p);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext ctx) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
        }
        return SHAPE_WEST;
    }

    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player interacting, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!interacting.m_6047_() && (blockEntity = level.m_7702_(pos)) instanceof ToiletBlockEntity) {
            ToiletBlockEntity entity = (ToiletBlockEntity)blockEntity;
            return entity.use(state, level, pos, interacting, hand, hitResult);
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new ToiletBlockEntity(pos, state);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean f) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ToiletBlockEntity) {
            ToiletBlockEntity toilet = (ToiletBlockEntity)blockEntity;
            toilet.getDrops(level, pos).forEach(c -> {
                double d0 = EntityType.f_20461_.m_20678_();
                double d1 = 0.2;
                double d2 = d0 / 2.0;
                double d3 = Math.floor(pos.m_123341_()) + level.f_46441_.m_188500_() * d1 + d2;
                double d4 = Math.floor(pos.m_123342_()) + level.f_46441_.m_188500_() * d1;
                double d5 = Math.floor(pos.m_123343_()) + level.f_46441_.m_188500_() * d1 + d2;
                ItemEntity e = new ItemEntity(level, d3, d4, d5, c);
                e.m_20334_(level.f_46441_.m_216328_(0.0, 0.11485000171139836), level.f_46441_.m_216328_(0.2, 0.11485000171139836), level.f_46441_.m_216328_(0.0, 0.11485000171139836));
                e.m_32060_();
                level.m_7967_((Entity)e);
            });
        }
        super.m_6810_(state, level, pos, newState, f);
    }

    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull PathComputationType path) {
        return false;
    }

    public BlockState m_5573_(@Nonnull BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(@Nonnull BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Deprecated
    public BlockState m_7417_(@Nonnull BlockState blockState, @Nonnull Direction direction, @Nonnull BlockState facingState, @Nonnull LevelAccessor levelAccessor, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, facingState, levelAccessor, currentPos, facingPos);
    }
}

