/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.services;

import com.blamejared.crafttweaker.platform.sides.DistributionType;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public interface IDistributionHelper {
    default public void runOn(DistributionType dist, Supplier<Runnable> runnable) {
        if (this.getDistributionType() == dist) {
            runnable.get().run();
        }
    }

    default public void runOn(Supplier<Runnable> client, Supplier<Runnable> server) {
        if (this.getDistributionType().isClient()) {
            client.get().run();
        } else {
            server.get().run();
        }
    }

    default public <T> Optional<T> callOn(DistributionType dist, Supplier<Callable<T>> toCall) {
        if (this.getDistributionType() == dist) {
            try {
                return Optional.of(toCall.get().call());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Optional.empty();
    }

    default public <T> Optional<T> callOn(Supplier<Supplier<T>> client, Supplier<Supplier<T>> server) {
        return switch (this.getDistributionType()) {
            default -> throw new IncompatibleClassChangeError();
            case DistributionType.CLIENT -> Optional.of(client.get().get());
            case DistributionType.SERVER -> Optional.of(server.get().get());
        };
    }

    public DistributionType getDistributionType();

    default public boolean isClient() {
        return this.getDistributionType().isClient();
    }

    default public boolean isServer() {
        return this.getDistributionType().isServer();
    }
}

