/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.castirongrill.common.blockentities;

import com.hermitowo.castirongrill.common.blockentities.CIGBlockEntities;
import com.hermitowo.castirongrill.common.container.CastIronGrillContainer;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CastIronGrillBlockEntity
extends AbstractFirepitBlockEntity<ItemStackHandler> {
    public static final int SLOT_EXTRA_INPUT_START = 4;
    public static final int SLOT_EXTRA_INPUT_END = 5;
    private static final Component NAME = Component.m_237115_((String)"castirongrill.block_entity.cast_iron_grill");
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[2];

    public CastIronGrillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CIGBlockEntities.CAST_IRON_GRILL.get(), pos, state, CastIronGrillBlockEntity.defaultInventory((int)6), NAME);
        if (((Boolean)TFCConfig.SERVER.firePitEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).insert(new int[]{3}).extract(new int[]{4, 5}), (Predicate)Direction.Plane.HORIZONTAL).on((Object)new PartialItemHandler(this.inventory).insert(new int[]{4, 5}), new Direction[]{Direction.UP});
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInv, Player player) {
        return CastIronGrillContainer.create(this, playerInv, windowID);
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot >= 4 && slot <= 5) {
            return stack.getCapability(HeatCapability.CAPABILITY).isPresent();
        }
        return super.isItemValid(slot, stack);
    }

    protected void handleCooking() {
        assert (this.f_58857_ != null);
        int slot = 4;
        while (slot <= 5) {
            ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            int finalSlot = slot++;
            inputStack.getCapability(HeatCapability.CAPABILITY, null).ifPresent(cap -> {
                HeatCapability.addTemp((IHeat)cap, (float)this.temperature);
                HeatingRecipe recipe = this.cachedRecipes[finalSlot - 4];
                if (recipe != null && recipe.isValidTemperature(cap.getTemperature())) {
                    ItemStack output = recipe.assemble(new ItemStackInventory(inputStack), this.f_58857_.m_9598_());
                    FoodCapability.applyTrait((ItemStack)output, (FoodTrait)FoodTraits.WOOD_GRILLED);
                    ((ItemStackHandler)this.inventory).setStackInSlot(finalSlot, output);
                    this.markForSync();
                }
            });
        }
    }

    protected void coolInstantly() {
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            stack.getCapability(HeatCapability.CAPABILITY).ifPresent(cap -> cap.setTemperature(0.0f));
        }
    }

    protected void updateCachedRecipe() {
        assert (this.f_58857_ != null);
        for (int slot = 4; slot <= 5; ++slot) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            this.cachedRecipes[slot - 4] = stack.m_41619_() ? null : HeatingRecipe.getRecipe((ItemStackInventory)new ItemStackInventory(stack));
        }
    }
}

