/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.INameMappingService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraftforge.fml.loading.LogMarkers;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class MCPNamingService
implements INameMappingService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private HashMap<String, String> methods;
    private HashMap<String, String> fields;

    public String mappingName() {
        return "srgtomcp";
    }

    public String mappingVersion() {
        return "1234";
    }

    public Map.Entry<String, String> understanding() {
        return Pair.of((Object)"srg", (Object)"mcp");
    }

    public BiFunction<INameMappingService.Domain, String, String> namingFunction() {
        return this::findMapping;
    }

    private String findMapping(INameMappingService.Domain domain, String srgName) {
        switch (domain) {
            case CLASS: {
                return srgName;
            }
            case FIELD: {
                return this.findFieldMapping(srgName);
            }
            case METHOD: {
                return this.findMethodMapping(srgName);
            }
        }
        return srgName;
    }

    private String findMethodMapping(String origin) {
        if (this.methods == null) {
            HashMap tmpmethods = new HashMap(1000);
            MCPNamingService.loadMappings("methods.csv", tmpmethods::put);
            this.methods = tmpmethods;
            LOGGER.debug(LogMarkers.CORE, "Loaded {} method mappings from methods.csv", (Object)this.methods.size());
        }
        return this.methods.getOrDefault(origin, origin);
    }

    private String findFieldMapping(String origin) {
        if (this.fields == null) {
            HashMap tmpfields = new HashMap(1000);
            MCPNamingService.loadMappings("fields.csv", tmpfields::put);
            this.fields = tmpfields;
            LOGGER.debug(LogMarkers.CORE, "Loaded {} field mappings from fields.csv", (Object)this.fields.size());
        }
        return this.fields.getOrDefault(origin, origin);
    }

    private static void loadMappings(String mappingFileName, BiConsumer<String, String> mapStore) {
        URL path = ClassLoader.getSystemResource(mappingFileName);
        if (path == null) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(path.openStream()));){
            reader.lines().skip(1L).map(e -> e.split(",")).forEach(e -> mapStore.accept(e[0], e[1]));
        }
        catch (IOException e1) {
            LOGGER.error(LogMarkers.CORE, "Error reading mappings", (Throwable)e1);
        }
    }
}

