/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.jarjar.metadata.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraftforge.jarjar.metadata.ContainedJarIdentifier;
import net.minecraftforge.jarjar.metadata.ContainedJarMetadata;
import net.minecraftforge.jarjar.metadata.ContainedVersion;

public class ContainedJarMetadataSerializer
implements JsonSerializer<ContainedJarMetadata>,
JsonDeserializer<ContainedJarMetadata> {
    public ContainedJarMetadata deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expected object");
        }
        JsonObject jsonObject = json.getAsJsonObject();
        ContainedJarIdentifier containedJarIdentifier = (ContainedJarIdentifier)context.deserialize(jsonObject.get("identifier"), ContainedJarIdentifier.class);
        ContainedVersion version = (ContainedVersion)context.deserialize(jsonObject.get("version"), ContainedVersion.class);
        String path = jsonObject.get("path").getAsString();
        boolean isObfuscated = false;
        if (jsonObject.has("isObfuscated")) {
            isObfuscated = jsonObject.get("isObfuscated").getAsBoolean();
        }
        return new ContainedJarMetadata(containedJarIdentifier, version, path, isObfuscated);
    }

    public JsonElement serialize(ContainedJarMetadata src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("identifier", context.serialize((Object)src.identifier()));
        jsonObject.add("version", context.serialize((Object)src.version()));
        jsonObject.add("path", (JsonElement)new JsonPrimitive(src.path()));
        jsonObject.add("isObfuscated", (JsonElement)new JsonPrimitive(Boolean.valueOf(src.isObfuscated())));
        return jsonObject;
    }
}

