/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.quickplay;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.GameType;
import org.slf4j.Logger;

public class QuickPlayLog {
    private static final QuickPlayLog f_278416_ = new QuickPlayLog(""){

        @Override
        public void m_278768_(Minecraft p_279484_) {
        }

        @Override
        public void m_278642_(Type p_279348_, String p_279305_, String p_279177_) {
        }
    };
    private static final Logger f_278438_ = LogUtils.getLogger();
    private static final Gson f_278422_ = new GsonBuilder().create();
    private final Path f_278473_;
    @Nullable
    private QuickPlayWorld f_278423_;

    QuickPlayLog(String p_279463_) {
        this.f_278473_ = Minecraft.m_91087_().f_91069_.toPath().resolve(p_279463_);
    }

    public static QuickPlayLog m_278648_(@Nullable String p_279275_) {
        if (p_279275_ == null) {
            return f_278416_;
        }
        return new QuickPlayLog(p_279275_);
    }

    public void m_278642_(Type p_279380_, String p_279427_, String p_279470_) {
        this.f_278423_ = new QuickPlayWorld(p_279380_, p_279427_, p_279470_);
    }

    public void m_278768_(Minecraft p_279258_) {
        if (p_279258_.f_91072_ == null || this.f_278423_ == null) {
            f_278438_.error("Failed to log session for quickplay. Missing world data or gamemode");
            return;
        }
        Util.m_183992_().execute(() -> {
            try {
                Files.deleteIfExists(this.f_278473_);
            }
            catch (IOException $$1) {
                f_278438_.error("Failed to delete quickplay log file {}", (Object)this.f_278473_, (Object)$$1);
            }
            QuickPlayEntry $$2 = new QuickPlayEntry(this.f_278423_, Instant.now(), p_279248_.f_91072_.m_105295_());
            Codec.list(QuickPlayEntry.f_278431_).encodeStart((DynamicOps)JsonOps.INSTANCE, List.of($$2)).resultOrPartial(Util.m_137489_("Quick Play: ", arg_0 -> ((Logger)f_278438_).error(arg_0))).ifPresent(p_279238_ -> {
                try {
                    Files.createDirectories(this.f_278473_.getParent(), new FileAttribute[0]);
                    Files.writeString(this.f_278473_, (CharSequence)f_278422_.toJson(p_279238_), new OpenOption[0]);
                }
                catch (IOException $$1) {
                    f_278438_.error("Failed to write to quickplay log file {}", (Object)this.f_278473_, (Object)$$1);
                }
            });
        });
    }

    record QuickPlayWorld(Type f_278464_, String f_278460_, String f_278469_) {
        public static final MapCodec<QuickPlayWorld> f_278511_ = RecordCodecBuilder.mapCodec(p_279181_ -> p_279181_.group((App)Type.f_278494_.fieldOf("type").forGetter(QuickPlayWorld::f_278464_), (App)Codec.STRING.fieldOf("id").forGetter(QuickPlayWorld::f_278460_), (App)Codec.STRING.fieldOf("name").forGetter(QuickPlayWorld::f_278469_)).apply((Applicative)p_279181_, QuickPlayWorld::new));

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{QuickPlayWorld.class, "type;id;name", "f_278464_", "f_278460_", "f_278469_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{QuickPlayWorld.class, "type;id;name", "f_278464_", "f_278460_", "f_278469_"}, this);
        }

        @Override
        public final boolean equals(Object p_279171_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{QuickPlayWorld.class, "type;id;name", "f_278464_", "f_278460_", "f_278469_"}, this, p_279171_);
        }
    }

    public static final class Type
    extends Enum<Type>
    implements StringRepresentable {
        public static final /* enum */ Type SINGLEPLAYER = new Type("singleplayer");
        public static final /* enum */ Type MULTIPLAYER = new Type("multiplayer");
        public static final /* enum */ Type REALMS = new Type("realms");
        static final Codec<Type> f_278494_;
        private final String f_278427_;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String p_279142_) {
            return Enum.valueOf(Type.class, p_279142_);
        }

        private Type(String p_279349_) {
            this.f_278427_ = p_279349_;
        }

        @Override
        public String m_7912_() {
            return this.f_278427_;
        }

        private static /* synthetic */ Type[] m_278856_() {
            return new Type[]{SINGLEPLAYER, MULTIPLAYER, REALMS};
        }

        static {
            $VALUES = Type.m_278856_();
            f_278494_ = StringRepresentable.m_216439_(Type::values);
        }
    }

    record QuickPlayEntry(QuickPlayWorld f_278426_, Instant f_278512_, GameType f_278456_) {
        public static final Codec<QuickPlayEntry> f_278431_ = RecordCodecBuilder.create(p_279196_ -> p_279196_.group((App)QuickPlayWorld.f_278511_.forGetter(QuickPlayEntry::f_278426_), (App)ExtraCodecs.f_216159_.fieldOf("lastPlayedTime").forGetter(QuickPlayEntry::f_278512_), (App)GameType.f_262729_.fieldOf("gamemode").forGetter(QuickPlayEntry::f_278456_)).apply((Applicative)p_279196_, QuickPlayEntry::new));

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{QuickPlayEntry.class, "quickPlayWorld;lastPlayedTime;gamemode", "f_278426_", "f_278512_", "f_278456_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{QuickPlayEntry.class, "quickPlayWorld;lastPlayedTime;gamemode", "f_278426_", "f_278512_", "f_278456_"}, this);
        }

        @Override
        public final boolean equals(Object p_279480_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{QuickPlayEntry.class, "quickPlayWorld;lastPlayedTime;gamemode", "f_278426_", "f_278512_", "f_278456_"}, this, p_279480_);
        }
    }
}

