/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.logging;

import java.util.function.Supplier;
import org.fusesource.jansi.AnsiConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.gravit.utils.helper.FormatHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.logging.LogHelperAppender;

public class Slf4jLogHelperImpl
implements LogHelperAppender {
    private final Logger logger = LoggerFactory.getLogger("LogHelper");
    private final boolean JANSI;

    public Slf4jLogHelperImpl() {
        boolean jansi;
        try {
            if (Boolean.getBoolean("launcher.noJAnsi")) {
                jansi = false;
            } else {
                Class.forName("org.fusesource.jansi.Ansi");
                AnsiConsole.systemInstall();
                jansi = true;
            }
        }
        catch (ClassNotFoundException ignored) {
            jansi = false;
        }
        this.JANSI = jansi;
    }

    @Override
    public void log(LogHelper.Level level, String message, boolean sub) {
        switch (level) {
            case DEV: {
                this.logger.trace(message);
                break;
            }
            case DEBUG: {
                this.logger.debug(message);
                break;
            }
            case INFO: {
                this.logger.info(message);
                break;
            }
            case WARNING: {
                this.logger.warn(message);
                break;
            }
            case ERROR: {
                this.logger.error(message);
            }
        }
    }

    @Override
    public void logJAnsi(LogHelper.Level level, Supplier<String> plaintext, Supplier<String> jansitext, boolean sub) {
        if (this.JANSI) {
            this.log(level, jansitext.get(), sub);
        } else {
            this.log(level, plaintext.get(), sub);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public void setDebugEnabled(boolean debugEnabled) {
    }

    @Override
    public boolean isStacktraceEnabled() {
        return true;
    }

    @Override
    public void setStacktraceEnabled(boolean stacktraceEnabled) {
    }

    @Override
    public boolean isDevEnabled() {
        return true;
    }

    @Override
    public void setDevEnabled(boolean stacktraceEnabled) {
    }

    @Override
    public void addOutput(LogHelper.OutputEnity output) {
    }

    @Override
    public boolean removeOutput(LogHelper.OutputEnity output) {
        return false;
    }

    @Override
    public void printVersion(String product) {
        if (this.JANSI) {
            this.logger.info(FormatHelper.ansiFormatVersion(product));
        } else {
            this.logger.info(FormatHelper.formatVersion(product));
        }
    }

    @Override
    public void printLicense(String product) {
        if (this.JANSI) {
            this.logger.info(FormatHelper.ansiFormatLicense(product));
        } else {
            this.logger.info(FormatHelper.formatLicense(product));
        }
    }
}

