/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.utils.helper.VerifyHelper;

public class ProviderMap<R> {
    protected final Map<String, Class<? extends R>> PROVIDERS = new ConcurrentHashMap<String, Class<? extends R>>(4);
    protected final String name;
    protected boolean registredProviders = false;

    public ProviderMap(String name) {
        this.name = name;
    }

    public ProviderMap() {
        this.name = "Unnamed";
    }

    public String getName() {
        return this.name;
    }

    public void register(String name, Class<? extends R> adapter) {
        VerifyHelper.verifyIDName(name);
        VerifyHelper.putIfAbsent(this.PROVIDERS, name, Objects.requireNonNull(adapter, "adapter"), String.format("%s has been already registered: '%s'", this.name, name));
    }

    public Class<? extends R> getClass(String name) {
        return this.PROVIDERS.get(name);
    }

    public String getName(Class<? extends R> clazz) {
        for (Map.Entry<String, Class<R>> e : this.PROVIDERS.entrySet()) {
            if (!e.getValue().equals(clazz)) continue;
            return e.getKey();
        }
        return null;
    }

    public Class<? extends R> unregister(String name) {
        return this.PROVIDERS.remove(name);
    }
}

