/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import pro.gravit.launcher.AsyncDownloader;
import pro.gravit.utils.helper.LogHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Downloader {
    private final CompletableFuture<Void> future;
    private final AsyncDownloader asyncDownloader;

    private Downloader(CompletableFuture<Void> future, AsyncDownloader downloader) {
        this.future = future;
        this.asyncDownloader = downloader;
    }

    public static Downloader downloadList(List<AsyncDownloader.SizedFile> files, String baseURL, Path targetDir, DownloadCallback callback, ExecutorService executor, int threads) {
        boolean closeExecutor;
        LogHelper.info("Download with legacy mode");
        if (executor == null) {
            executor = Executors.newWorkStealingPool(4);
            closeExecutor = true;
        } else {
            closeExecutor = false;
        }
        AsyncDownloader asyncDownloader = new AsyncDownloader(diff -> {
            if (callback != null) {
                callback.apply(diff);
            }
        });
        List<List<AsyncDownloader.SizedFile>> list = asyncDownloader.sortFiles(files, threads);
        CompletableFuture<Void> future = CompletableFuture.allOf(asyncDownloader.runDownloadList(list, baseURL, targetDir, executor));
        ExecutorService finalExecutor = executor;
        return new Downloader((CompletableFuture<Void>)future.thenAccept(e -> {
            if (closeExecutor) {
                finalExecutor.shutdownNow();
            }
        }), asyncDownloader);
    }

    public CompletableFuture<Void> getFuture() {
        return this.future;
    }

    public void cancel() {
        this.asyncDownloader.isClosed = true;
    }

    public boolean isCanceled() {
        return this.asyncDownloader.isClosed;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface DownloadCallback {
        public void apply(long var1);

        public void onComplete(Path var1);
    }
}

