/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.serialize;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.utils.helper.IOHelper;

public final class HInput
implements AutoCloseable {
    public final InputStream stream;

    public HInput(byte[] bytes) {
        this.stream = new ByteArrayInputStream(bytes);
    }

    public HInput(InputStream stream) {
        this.stream = Objects.requireNonNull(stream, "stream");
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    public String readASCII(int maxBytes) throws IOException {
        return IOHelper.decodeASCII(this.readByteArray(maxBytes));
    }

    public BigInteger readBigInteger(int maxBytes) throws IOException {
        return new BigInteger(this.readByteArray(maxBytes));
    }

    public boolean readBoolean() throws IOException {
        int b = this.readUnsignedByte();
        switch (b) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        throw new IOException("Invalid boolean state: " + b);
    }

    public byte[] readByteArray(int max) throws IOException {
        byte[] bytes = new byte[this.readLength(max)];
        IOHelper.read(this.stream, bytes);
        return bytes;
    }

    public int readInt() throws IOException {
        return (this.readUnsignedByte() << 24) + (this.readUnsignedByte() << 16) + (this.readUnsignedByte() << 8) + this.readUnsignedByte();
    }

    public int readLength(int max) throws IOException {
        if (max < 0) {
            return -max;
        }
        return IOHelper.verifyLength(this.readVarInt(), max);
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public short readShort() throws IOException {
        return (short)((this.readUnsignedByte() << 8) + this.readUnsignedByte());
    }

    public String readString(int maxBytes) throws IOException {
        return IOHelper.decode(this.readByteArray(maxBytes));
    }

    public int readUnsignedByte() throws IOException {
        int b = this.stream.read();
        if (b < 0) {
            throw new EOFException("readUnsignedByte");
        }
        return b;
    }

    public int readUnsignedShort() throws IOException {
        return Short.toUnsignedInt(this.readShort());
    }

    public UUID readUUID() throws IOException {
        return new UUID(this.readLong(), this.readLong());
    }

    public int readVarInt() throws IOException {
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            int b = this.readUnsignedByte();
            result |= (b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("VarInt too big");
    }

    public long readVarLong() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            int b = this.readUnsignedByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new IOException("VarLong too big");
    }
}

