/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.LogHelper;

public class OfflineRequestService
implements RequestService {
    private final HashSet<RequestService.EventHandler> eventHandlers = new HashSet();
    private final Map<Class<?>, RequestProcessor<?, ?>> processors = new ConcurrentHashMap();

    @Override
    public <T extends WebSocketEvent> CompletableFuture<T> request(Request<T> request) {
        RequestProcessor<?, ?> processor = this.processors.get(request.getClass());
        CompletableFuture future = new CompletableFuture();
        if (processor == null) {
            future.completeExceptionally(new RequestException(String.format("Offline mode not support '%s'", request.getType())));
            return future;
        }
        if (LogHelper.isDevEnabled()) {
            LogHelper.dev("Request %s: %s", request.getType(), Launcher.gsonManager.gson.toJson(request));
        }
        try {
            Object event = processor.process(request);
            if (LogHelper.isDevEnabled()) {
                LogHelper.dev("Response %s: %s", event.getType(), Launcher.gsonManager.gson.toJson(event));
            }
            future.complete(event);
        }
        catch (Throwable e) {
            if (e instanceof RequestException) {
                future.completeExceptionally(e);
            }
            future.completeExceptionally(new RequestException(e));
        }
        return future;
    }

    @Override
    public void registerEventHandler(RequestService.EventHandler handler) {
        this.eventHandlers.add(handler);
    }

    @Override
    public void unregisterEventHandler(RequestService.EventHandler handler) {
        this.eventHandlers.remove(handler);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public <T extends WebSocketEvent, V extends WebSocketRequest> void registerRequestProcessor(Class<V> requestClazz, RequestProcessor<T, V> function) {
        this.processors.put(requestClazz, function);
    }

    public <T extends WebSocketEvent> void unregisterRequestProcessor(Class<Request<T>> requestClazz) {
        this.processors.remove(requestClazz);
    }

    public static interface RequestProcessor<T extends WebSocketEvent, V extends WebSocketRequest> {
        public T process(V var1) throws RequestException;
    }
}

