/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.request.websockets;

import java.io.IOException;
import java.net.URI;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;
import pro.gravit.launcher.CertificatePinningTrustManager;
import pro.gravit.launcher.request.websockets.WebSocketClientHandler;
import pro.gravit.repackage.io.netty.bootstrap.Bootstrap;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelInitializer;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.EventLoopGroup;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoopGroup;
import pro.gravit.repackage.io.netty.channel.socket.SocketChannel;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioSocketChannel;
import pro.gravit.repackage.io.netty.handler.codec.http.EmptyHttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpClientCodec;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpObjectAggregator;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import pro.gravit.repackage.io.netty.handler.ssl.SslContext;
import pro.gravit.repackage.io.netty.handler.ssl.SslContextBuilder;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.GenericFutureListener;
import pro.gravit.utils.helper.LogHelper;

public abstract class ClientJSONPoint {
    private static final AtomicInteger counter = new AtomicInteger();
    private static final ThreadFactory threadFactory = runnable -> {
        Thread t = new Thread(runnable);
        t.setName(String.format("Netty Thread #%d", counter.incrementAndGet()));
        t.setDaemon(true);
        return t;
    };
    private static final EventLoopGroup group = new NioEventLoopGroup(threadFactory);
    private static boolean isCertificatePinning = false;
    protected final Bootstrap bootstrap = new Bootstrap();
    private final URI uri;
    public boolean isClosed;
    protected Channel ch;
    protected WebSocketClientHandler webSocketClientHandler;
    protected boolean ssl = false;
    protected int port;

    public ClientJSONPoint(String uri) throws SSLException {
        this(URI.create(uri));
    }

    public ClientJSONPoint(final URI uri) throws SSLException {
        SslContext sslCtx;
        this.uri = uri;
        String protocol = uri.getScheme();
        if (!"ws".equals(protocol) && !"wss".equals(protocol)) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        if ("wss".equals(protocol)) {
            this.ssl = true;
        }
        this.port = uri.getPort() == -1 ? ("ws".equals(protocol) ? 80 : 443) : uri.getPort();
        if (this.ssl) {
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
            if (isCertificatePinning) {
                try {
                    sslContextBuilder.trustManager(CertificatePinningTrustManager.getTrustManager());
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    LogHelper.error(e);
                    sslContextBuilder.trustManager(new X509Certificate[0]);
                }
            }
            sslCtx = sslContextBuilder.build();
        } else {
            sslCtx = null;
        }
        ((Bootstrap)((Bootstrap)this.bootstrap.group(group)).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                if (sslCtx != null) {
                    pipeline.addLast(sslCtx.newHandler(ch.alloc(), uri.getHost(), ClientJSONPoint.this.port));
                }
                pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(65536));
                pipeline.addLast("ws-handler", (ChannelHandler)ClientJSONPoint.this.webSocketClientHandler);
            }
        });
    }

    public void open() throws Exception {
        this.webSocketClientHandler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker(this.uri, WebSocketVersion.V13, null, false, EmptyHttpHeaders.INSTANCE, 12800000), this);
        this.ch = this.bootstrap.connect(this.uri.getHost(), this.port).sync().channel();
        this.webSocketClientHandler.handshakeFuture().sync();
    }

    public void openAsync(Runnable onConnect, Consumer<Throwable> onFail) {
        this.webSocketClientHandler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker(this.uri, WebSocketVersion.V13, null, false, EmptyHttpHeaders.INSTANCE, 12800000), this);
        ChannelFuture future = this.bootstrap.connect(this.uri.getHost(), this.port);
        future.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)l -> {
            if (l.isSuccess()) {
                this.ch = future.channel();
                this.webSocketClientHandler.handshakeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)e -> {
                    if (e.isSuccess()) {
                        onConnect.run();
                    } else {
                        onFail.accept(this.webSocketClientHandler.handshakeFuture().cause());
                    }
                }));
            } else {
                onFail.accept(future.cause());
            }
        }));
    }

    public void send(String text) {
        LogHelper.dev("Send: %s", text);
        this.ch.writeAndFlush(new TextWebSocketFrame(text), this.ch.voidPromise());
    }

    abstract void onMessage(String var1);

    abstract void onDisconnect();

    abstract void onOpen();

    public void close() throws InterruptedException {
        this.isClosed = true;
        if (this.ch != null && this.ch.isActive()) {
            this.ch.writeAndFlush(new CloseWebSocketFrame(), this.ch.voidPromise());
            this.ch.closeFuture().sync();
        }
        group.shutdownGracefully();
    }

    public void eval(String text) {
        this.ch.writeAndFlush(new TextWebSocketFrame(text), this.ch.voidPromise());
    }
}

