/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.utils;

import java.util.Locale;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.service.StateService;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTriggerContext;
import pro.gravit.utils.helper.JavaHelper;

public class TriggerManager {
    private final StateService stateService;
    private final JavaFXApplication application;

    public TriggerManager(JavaFXApplication application) {
        this.stateService = application.stateService;
        this.application = application;
    }

    public void process(ClientProfile profile, OptionalView view) {
        TriggerManagerContext context = new TriggerManagerContext(profile);
        for (OptionalFile optional : view.all) {
            if (optional.limited) {
                if (!this.stateService.checkPermission(String.format("launcher.runtime.optionals.%s.%s.show", profile.getUUID(), optional.name.toLowerCase(Locale.ROOT)))) {
                    view.disable(optional, null);
                    optional.visible = false;
                } else {
                    optional.visible = true;
                }
            }
            if (optional.triggersList == null) continue;
            boolean isRequired = false;
            int success = 0;
            int fail = 0;
            for (OptionalTrigger trigger : optional.triggersList) {
                if (trigger.required) {
                    isRequired = true;
                }
                if (trigger.check(optional, context)) {
                    ++success;
                    continue;
                }
                ++fail;
            }
            if (isRequired) {
                if (fail == 0) {
                    view.enable(optional, true, null);
                    continue;
                }
                view.disable(optional, null);
                continue;
            }
            if (success <= 0) continue;
            view.enable(optional, false, null);
        }
    }

    private class TriggerManagerContext
    implements OptionalTriggerContext {
        private final ClientProfile profile;

        private TriggerManagerContext(ClientProfile profile) {
            this.profile = profile;
        }

        @Override
        public ClientProfile getProfile() {
            return this.profile;
        }

        @Override
        public String getUsername() {
            return TriggerManager.this.stateService.getUsername();
        }

        @Override
        public JavaHelper.JavaVersion getJavaVersion() {
            RuntimeSettings.ProfileSettings profileSettings = TriggerManager.this.application.getProfileSettings(this.profile);
            for (JavaHelper.JavaVersion version : ((TriggerManager)TriggerManager.this).application.javaService.javaVersions) {
                if (profileSettings.javaPath == null || !profileSettings.javaPath.equals(version.jvmDir.toString())) continue;
                return version;
            }
            return JavaHelper.JavaVersion.getCurrentJavaVersion();
        }
    }
}

