/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.stage;

import java.io.IOException;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.stage.Screen;
import javafx.stage.StageStyle;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.AbstractStage;
import pro.gravit.utils.helper.LogHelper;

public class DialogStage
extends AbstractStage {
    public DialogStage(JavaFXApplication application, String title, AbstractDialog dialog) throws Exception {
        super(application.newStage());
        this.stage.setTitle(title);
        this.stage.initStyle(StageStyle.TRANSPARENT);
        this.stage.setResizable(false);
        this.stage.setOnCloseRequest(e -> e.consume());
        try {
            Image icon = new Image(JavaFXApplication.getResourceURL("favicon.png").toString());
            this.stage.getIcons().add((Object)icon);
        }
        catch (IOException e2) {
            LogHelper.error(e2);
        }
        this.setScene(dialog);
        this.enableMouseDrag((Node)dialog.getLayout());
        Screen screen = Screen.getPrimary();
        Rectangle2D bounds = screen.getVisualBounds();
        if (bounds.getMaxX() == 0.0 || bounds.getMaxY() == 0.0) {
            bounds = screen.getBounds();
        }
        LogHelper.info("Bounds: X: %f Y: %f", bounds.getMaxX(), bounds.getMaxY());
        LookupHelper.Point2D coords = dialog.getOutSceneCoords(bounds);
        this.stage.setX(coords.x);
        this.stage.setY(coords.y);
    }
}

