/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.launcher.request.Request;

public class StateService {
    private AuthRequestEvent rawAuthResult;
    private List<ClientProfile> profiles;
    private ClientProfile profile;
    private Map<ClientProfile, OptionalView> optionalViewMap;
    private GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability;

    public void setAuthResult(String authId, AuthRequestEvent rawAuthResult) {
        this.rawAuthResult = rawAuthResult;
        if (rawAuthResult.oauth != null) {
            Request.setOAuth(authId, rawAuthResult.oauth);
        }
    }

    public void setAuthAvailability(GetAvailabilityAuthRequestEvent.AuthAvailability info) {
        this.authAvailability = info;
    }

    public GetAvailabilityAuthRequestEvent.AuthAvailability getAuthAvailability() {
        return this.authAvailability;
    }

    public boolean isSupportedAuthFeature(String feature) {
        if (this.authAvailability == null || this.authAvailability.apiFeatures == null) {
            return false;
        }
        return this.authAvailability.apiFeatures.contains(feature);
    }

    public String getApiUrl() {
        if (this.authAvailability == null || this.authAvailability.apiUrl == null) {
            return null;
        }
        return this.authAvailability.apiUrl;
    }

    public Map<ClientProfile, OptionalView> getOptionalViewMap() {
        return this.optionalViewMap;
    }

    public void setOptionalView(ClientProfile profile, OptionalView view) {
        this.optionalViewMap.put(profile, view);
    }

    public void setProfilesResult(ProfilesRequestEvent rawProfilesResult) {
        this.profiles = rawProfilesResult.profiles;
        this.profiles.sort(ClientProfile::compareTo);
        if (this.optionalViewMap == null) {
            this.optionalViewMap = new HashMap<ClientProfile, OptionalView>();
        }
        for (ClientProfile profile : this.profiles) {
            OptionalView oldView = this.optionalViewMap.get(profile);
            OptionalView newView = oldView != null ? new OptionalView(profile, oldView) : new OptionalView(profile);
            this.optionalViewMap.put(profile, newView);
        }
    }

    public String getUsername() {
        if (this.rawAuthResult == null || this.rawAuthResult.playerProfile == null) {
            return "Player";
        }
        return this.rawAuthResult.playerProfile.username;
    }

    public String getMainRole() {
        if (this.rawAuthResult == null || this.rawAuthResult.permissions == null || this.rawAuthResult.permissions.getRoles() == null || this.rawAuthResult.permissions.getRoles().isEmpty()) {
            return "";
        }
        return this.rawAuthResult.permissions.getRoles().get(0);
    }

    public boolean checkPermission(String name) {
        if (this.rawAuthResult == null || this.rawAuthResult.permissions == null) {
            return false;
        }
        return this.rawAuthResult.permissions.hasPerm(name);
    }

    public List<ClientProfile> getProfiles() {
        return this.profiles;
    }

    public ClientProfile getProfile() {
        return this.profile;
    }

    public void setProfile(ClientProfile profile) {
        this.profile = profile;
    }

    public OptionalView getOptionalView() {
        return this.optionalViewMap.get(this.profile);
    }

    public OptionalView getOptionalView(ClientProfile profile) {
        return this.optionalViewMap.get(profile);
    }

    public PlayerProfile getPlayerProfile() {
        if (this.rawAuthResult == null) {
            return null;
        }
        return this.rawAuthResult.playerProfile;
    }

    public String getAccessToken() {
        if (this.rawAuthResult == null) {
            return null;
        }
        return this.rawAuthResult.accessToken;
    }

    public void exit() {
        this.rawAuthResult = null;
        this.profile = null;
    }
}

