/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.update;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javafx.beans.property.DoubleProperty;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.text.Text;
import pro.gravit.launcher.AsyncDownloader;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.scenes.update.AssetIndexHelper;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.hasher.HashedEntry;
import pro.gravit.launcher.hasher.HashedFile;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.actions.OptionalActionFile;
import pro.gravit.launcher.request.update.UpdateRequest;
import pro.gravit.utils.Downloader;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class VisualDownloader {
    private final JavaFXApplication application;
    private final AtomicLong totalDownloaded = new AtomicLong(0L);
    private final AtomicLong lastUpdateTime = new AtomicLong(0L);
    private final AtomicLong lastDownloaded = new AtomicLong(0L);
    private volatile long totalSize;
    private volatile Downloader downloader;
    private final ProgressBar progressBar;
    private final Text speed;
    private final Label volume;
    private final Consumer<Throwable> errorHandle;
    private final Consumer<String> addLog;
    private final ExecutorService executor;

    public VisualDownloader(JavaFXApplication application, ProgressBar progressBar, Text speed, Label volume, Consumer<Throwable> errorHandle, Consumer<String> addLog) {
        this.application = application;
        this.progressBar = progressBar;
        this.speed = speed;
        this.volume = volume;
        this.errorHandle = errorHandle;
        this.addLog = addLog;
        this.executor = new ForkJoinPool(application.guiModuleConfig.downloadThreads, pool -> {
            ForkJoinWorkerThread thread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            thread.setDaemon(true);
            return thread;
        }, null, true);
    }

    public void sendUpdateAssetRequest(String dirName, Path dir, FileNameMatcher matcher, boolean digest, String assetIndex, Consumer<HashedDir> onSuccess) {
        if (this.application.offlineService.isOfflineMode()) {
            this.addLog.accept(String.format("Hashing %s", dirName));
            this.application.workers.submit(() -> {
                try {
                    HashedDir hashedDir = new HashedDir(dir, matcher, false, digest);
                    onSuccess.accept(hashedDir);
                }
                catch (IOException e) {
                    this.errorHandle.accept(e);
                }
            });
            return;
        }
        UpdateRequest request = new UpdateRequest(dirName);
        try {
            ((CompletableFuture)this.application.service.request(request).thenAccept(event -> {
                LogHelper.dev("Start updating %s", dirName);
                try {
                    this.downloadAsset(dirName, dir, matcher, digest, assetIndex, onSuccess, event.hdir, event.url);
                }
                catch (Exception e) {
                    ContextHelper.runInFxThreadStatic(() -> this.errorHandle.accept(e));
                }
            })).exceptionally(error -> {
                ContextHelper.runInFxThreadStatic(() -> this.errorHandle.accept(error.getCause()));
                return null;
            });
        }
        catch (IOException e) {
            this.errorHandle.accept(e);
        }
    }

    public void sendUpdateRequest(String dirName, Path dir, FileNameMatcher matcher, boolean digest, OptionalView view, boolean optionalsEnabled, Consumer<HashedDir> onSuccess) {
        if (this.application.offlineService.isOfflineMode()) {
            this.addLog.accept(String.format("Hashing %s", dirName));
            this.application.workers.submit(() -> {
                try {
                    HashedDir hashedDir = new HashedDir(dir, matcher, false, digest);
                    onSuccess.accept(hashedDir);
                }
                catch (IOException e) {
                    this.errorHandle.accept(e);
                }
            });
            return;
        }
        UpdateRequest request = new UpdateRequest(dirName);
        try {
            ((CompletableFuture)this.application.service.request(request).thenAccept(event -> {
                LogHelper.dev("Start updating %s", dirName);
                try {
                    this.download(dirName, dir, matcher, digest, view, optionalsEnabled, onSuccess, event.hdir, event.url);
                }
                catch (Exception e) {
                    ContextHelper.runInFxThreadStatic(() -> this.errorHandle.accept(e));
                }
            })).exceptionally(error -> {
                ContextHelper.runInFxThreadStatic(() -> this.errorHandle.accept(error.getCause()));
                return null;
            });
        }
        catch (IOException e) {
            this.errorHandle.accept(e);
        }
    }

    private void download(String dirName, Path dir, FileNameMatcher matcher, boolean digest, OptionalView view, boolean optionalsEnabled, Consumer<HashedDir> onSuccess, HashedDir targetHDir, String baseUrl) throws Exception {
        LinkedList<PathRemapperData> pathRemapper = optionalsEnabled ? this.getPathRemapper(view, targetHDir) : new LinkedList();
        this.addLog.accept(String.format("Hashing %s", dirName));
        if (!IOHelper.exists(dir)) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        HashedDir hashedDir = new HashedDir(dir, matcher, false, digest);
        HashedDir.Diff diff = targetHDir.diff(hashedDir, matcher);
        List<AsyncDownloader.SizedFile> adds = this.getFilesList(dir, pathRemapper, diff.mismatch);
        LogHelper.info("Diff %d %d", diff.mismatch.size(), diff.extra.size());
        this.addLog.accept(String.format("Downloading %s...", dirName));
        this.downloadFiles(dir, adds, baseUrl, () -> {
            try {
                this.addLog.accept(String.format("Delete Extra files %s", dirName));
                this.deleteExtraDir(dir, diff.extra, diff.extra.flag);
                onSuccess.accept(targetHDir);
            }
            catch (IOException e) {
                this.errorHandle.accept(e);
            }
        });
    }

    private void downloadAsset(String dirName, Path dir, FileNameMatcher matcher, boolean digest, String assetIndex, Consumer<HashedDir> onSuccess, HashedDir targetHDir, String baseUrl) throws Exception {
        boolean needUpdateIndex;
        LinkedList pathRemapper = new LinkedList();
        this.addLog.accept(String.format("Check assetIndex %s", assetIndex));
        if (!IOHelper.exists(dir)) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        Consumer<HashedDir> downloadAssetRunnable = assetHDir -> {
            try {
                HashedDir hashedDir = new HashedDir(dir, matcher, false, digest);
                HashedDir.Diff diff = assetHDir.diff(hashedDir, matcher);
                List<AsyncDownloader.SizedFile> adds = this.getFilesList(dir, pathRemapper, diff.mismatch);
                LogHelper.info("Diff %d %d", diff.mismatch.size(), diff.extra.size());
                this.addLog.accept(String.format("Downloading %s...", dirName));
                this.downloadFiles(dir, adds, baseUrl, () -> {
                    try {
                        onSuccess.accept((HashedDir)assetHDir);
                    }
                    catch (Exception e) {
                        this.errorHandle.accept(e);
                    }
                });
            }
            catch (Throwable e) {
                this.errorHandle.accept(e);
            }
        };
        String assetIndexPath = "indexes/".concat(assetIndex).concat(".json");
        Path localAssetIndexPath = dir.resolve(assetIndexPath);
        HashedDir.FindRecursiveResult result = targetHDir.findRecursive(assetIndexPath);
        if (!(result.entry instanceof HashedFile)) {
            this.addLog.accept(String.format("ERROR: assetIndex %s not found", assetIndex));
            this.errorHandle.accept(new RuntimeException("assetIndex not found"));
            return;
        }
        if (Files.exists(localAssetIndexPath, new LinkOption[0])) {
            HashedFile file = new HashedFile(localAssetIndexPath, Files.size(localAssetIndexPath), true);
            needUpdateIndex = !((HashedFile)result.entry).isSame(file);
        } else {
            IOHelper.createParentDirs(localAssetIndexPath);
            needUpdateIndex = true;
        }
        if (needUpdateIndex) {
            ArrayList<AsyncDownloader.SizedFile> adds = new ArrayList<AsyncDownloader.SizedFile>(1);
            adds.add(new AsyncDownloader.SizedFile(assetIndexPath, ((HashedFile)result.entry).size));
            this.downloadFiles(dir, adds, baseUrl, () -> {
                try {
                    AssetIndexHelper.AssetIndex index = AssetIndexHelper.parse(localAssetIndexPath);
                    AssetIndexHelper.modifyHashedDir(index, targetHDir);
                    downloadAssetRunnable.accept(targetHDir);
                }
                catch (Exception e) {
                    this.errorHandle.accept(e);
                }
            });
        } else {
            try {
                AssetIndexHelper.AssetIndex index = AssetIndexHelper.parse(localAssetIndexPath);
                AssetIndexHelper.modifyHashedDir(index, targetHDir);
                downloadAssetRunnable.accept(targetHDir);
            }
            catch (Exception e) {
                this.errorHandle.accept(e);
            }
        }
    }

    private void downloadFiles(Path dir, List<AsyncDownloader.SizedFile> adds, String baseUrl, Runnable onSuccess) throws Exception {
        ContextHelper.runInFxThreadStatic(this::resetProgress).thenAccept(x -> {
            this.downloader = Downloader.downloadList(adds, baseUrl, dir, new Downloader.DownloadCallback(){

                @Override
                public void apply(long fullDiff) {
                    long old = VisualDownloader.this.totalDownloaded.getAndAdd(fullDiff);
                    VisualDownloader.this.updateProgress(old, old + fullDiff);
                }

                @Override
                public void onComplete(Path path) {
                }
            }, this.executor, this.application.guiModuleConfig.downloadThreads);
            ((CompletableFuture)this.downloader.getFuture().thenAccept(e -> onSuccess.run())).exceptionally(e -> {
                ContextHelper.runInFxThreadStatic(() -> this.errorHandle.accept((Throwable)e));
                return null;
            });
        });
    }

    private void resetProgress() {
        this.totalDownloaded.set(0L);
        this.lastUpdateTime.set(System.currentTimeMillis());
        this.lastDownloaded.set(0L);
        this.progressBar.progressProperty().setValue((Number)0);
    }

    private List<AsyncDownloader.SizedFile> getFilesList(Path dir, LinkedList<PathRemapperData> pathRemapper, HashedDir mismatch) throws IOException {
        this.totalSize = 0L;
        ArrayList<AsyncDownloader.SizedFile> adds = new ArrayList<AsyncDownloader.SizedFile>();
        mismatch.walk("/", (path, name, entry) -> {
            String urlPath = path;
            switch (entry.getType()) {
                case FILE: {
                    HashedFile file = (HashedFile)entry;
                    this.totalSize += file.size;
                    for (PathRemapperData remapEntry : pathRemapper) {
                        if (!path.startsWith(remapEntry.key)) continue;
                        urlPath = path.replace(remapEntry.key, remapEntry.value);
                        LogHelper.dev("Remap found: injected url path: %s | calculated original url path: %s", path, urlPath);
                    }
                    Files.deleteIfExists(dir.resolve(path));
                    adds.add(new AsyncDownloader.SizedFile(urlPath, path, file.size));
                    break;
                }
                case DIR: {
                    Files.createDirectories(dir.resolve(path), new FileAttribute[0]);
                }
            }
            return HashedDir.WalkAction.CONTINUE;
        });
        return adds;
    }

    private LinkedList<PathRemapperData> getPathRemapper(OptionalView view, HashedDir hdir) {
        for (OptionalAction action : view.getDisabledActions()) {
            if (!(action instanceof OptionalActionFile)) continue;
            ((OptionalActionFile)action).disableInHashedDir(hdir);
        }
        LinkedList<PathRemapperData> pathRemapper = new LinkedList<PathRemapperData>();
        Set<OptionalActionFile> fileActions = view.getActionsByClass(OptionalActionFile.class);
        for (OptionalActionFile file : fileActions) {
            file.injectToHashedDir(hdir);
            file.files.forEach((k, v) -> {
                if (v == null || v.isEmpty()) {
                    return;
                }
                pathRemapper.add(new PathRemapperData((String)v, (String)k));
                LogHelper.dev("Remap prepare %s to %s", v, k);
            });
        }
        pathRemapper.sort(Comparator.comparingInt(c -> -c.key.length()));
        return pathRemapper;
    }

    private void deleteExtraDir(Path subDir, HashedDir subHDir, boolean deleteDir) throws IOException {
        block4: for (Map.Entry<String, HashedEntry> mapEntry : subHDir.map().entrySet()) {
            String name = mapEntry.getKey();
            Path path = subDir.resolve(name);
            HashedEntry entry = mapEntry.getValue();
            HashedEntry.Type entryType = entry.getType();
            switch (entryType) {
                case FILE: {
                    Files.delete(path);
                    continue block4;
                }
                case DIR: {
                    this.deleteExtraDir(path, (HashedDir)entry, deleteDir || entry.flag);
                    continue block4;
                }
            }
            throw new AssertionError((Object)("Unsupported hashed entry type: " + entryType.name()));
        }
        if (deleteDir) {
            Files.delete(subDir);
        }
    }

    private void updateProgress(long oldValue, long newValue) {
        double add = (double)(newValue - oldValue) / (double)this.totalSize;
        DoubleProperty property = this.progressBar.progressProperty();
        property.set(property.get() + add);
        long lastTime = this.lastUpdateTime.get();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastTime >= 130L) {
            String format = String.format(" [%.1f MB]", (double)newValue / 1048576.0, (double)this.totalSize / 1048576.0);
            double bytesSpeed = (double)(newValue - this.lastDownloaded.get()) / (double)(currentTime - lastTime) * 1000.0;
            String speedFormat = String.format("%.2f ", bytesSpeed * 8.0 / 1000000.0);
            ContextHelper.runInFxThreadStatic(() -> {
                this.volume.setText(format);
                this.speed.setText(speedFormat);
            });
            this.lastUpdateTime.set(currentTime);
            this.lastDownloaded.set(newValue);
        }
    }

    public boolean isDownload() {
        return this.downloader != null && !this.downloader.getFuture().isDone();
    }

    public CompletableFuture<Void> getFuture() {
        return this.downloader.getFuture();
    }

    public void cancel() {
        this.downloader.cancel();
    }

    public boolean isCanceled() {
        return this.downloader.isCanceled();
    }

    private static class PathRemapperData {
        public String key;
        public String value;

        public PathRemapperData(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

