/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.update;

import java.nio.file.Path;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.text.Text;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.update.VisualDownloader;
import pro.gravit.launcher.hasher.FileNameMatcher;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.utils.helper.LogHelper;

public class UpdateScene
extends AbstractScene {
    private ProgressBar progressBar;
    private Text speed;
    private Label volume;
    private TextArea logOutput;
    private Text currentStatus;
    private Button reload;
    private Button cancel;
    private Text speedtext;
    private Text speederr;
    private VisualDownloader downloader;

    public UpdateScene(JavaFXApplication application) {
        super("scenes/update/update.fxml", application);
    }

    @Override
    protected void doInit() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#exit").ifPresent(b -> b.setOnAction(e -> this.currentStage.close()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#minimize").ifPresent(b -> b.setOnAction(e -> this.currentStage.hide()));
        this.progressBar = (ProgressBar)LookupHelper.lookup((Node)this.layout, "#progress");
        this.speed = (Text)LookupHelper.lookup((Node)this.layout, "#speed");
        this.speederr = (Text)LookupHelper.lookup((Node)this.layout, "#speedErr");
        this.speedtext = (Text)LookupHelper.lookup((Node)this.layout, "#speed-text");
        this.volume = (Label)LookupHelper.lookup((Node)this.layout, "#volume");
        this.logOutput = (TextArea)LookupHelper.lookup((Node)this.layout, "#outputUpdate");
        this.logOutput.setText("");
        this.downloader = new VisualDownloader(this.application, this.progressBar, this.speed, this.volume, this::errorHandle, log -> this.contextHelper.runInFxThread(() -> this.addLog((String)log)));
    }

    public void sendUpdateAssetRequest(String dirName, Path dir, FileNameMatcher matcher, boolean digest, String assetIndex, Consumer<HashedDir> onSuccess) {
        this.downloader.sendUpdateAssetRequest(dirName, dir, matcher, digest, assetIndex, onSuccess);
    }

    public void sendUpdateRequest(String dirName, Path dir, FileNameMatcher matcher, boolean digest, OptionalView view, boolean optionalsEnabled, Consumer<HashedDir> onSuccess) {
        this.downloader.sendUpdateRequest(dirName, dir, matcher, digest, view, optionalsEnabled, onSuccess);
    }

    public void addLog(String string) {
        LogHelper.dev("Update event %s", string);
        this.logOutput.appendText(string.concat("\n"));
    }

    @Override
    public void reset() {
        this.progressBar.progressProperty().setValue((Number)0);
        this.logOutput.clear();
        this.volume.setText("");
        this.speed.setText("0");
        this.cancel.setDisable(false);
        this.cancel.setStyle("-fx-opacity: 1");
        this.progressBar.getStyleClass().removeAll((Object[])new String[]{"progress"});
        this.speed.getStyleClass().removeAll((Object[])new String[]{"speedError"});
        this.speed.setStyle("-fx-opacity: 1");
        this.speedtext.setStyle("-fx-opacity: 1");
        this.speederr.setStyle("-fx-opacity: 0");
    }

    @Override
    public void errorHandle(Throwable e) {
        this.addLog(String.format("Exception %s: %s", e.getClass(), e.getMessage() == null ? "" : e.getMessage()));
        this.progressBar.getStyleClass().add((Object)"progressError");
        this.speed.setStyle("-fx-opacity: 0");
        this.speedtext.setStyle("-fx-opacity: 0");
        this.speederr.setStyle("-fx-opacity: 1");
        LogHelper.error(e);
        this.cancel.setDisable(true);
        this.cancel.setStyle("-fx-opacity: 0");
    }

    @Override
    public String getName() {
        return "update";
    }
}

