/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.settings;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Slider;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import javafx.util.StringConverter;
import oshi.SystemInfo;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerButtonComponent;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.client.gui.scenes.settings.JavaSelectorComponent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class SettingsScene
extends AbstractScene {
    private static final long MAX_JAVA_MEMORY_X64 = 32768L;
    private static final long MAX_JAVA_MEMORY_X32 = 1536L;
    private Pane componentList;
    private Label ramLabel;
    private Slider ramSlider;
    private RuntimeSettings.ProfileSettingsView profileSettings;
    private JavaSelectorComponent javaSelector;
    private ImageView avatar;
    private Image originalAvatarImage;
    private Button saveButton;

    public SettingsScene(JavaFXApplication application) {
        super("scenes/settings/settings.fxml", application);
    }

    public void enableSaveButton(String text, EventHandler<ActionEvent> eventHandler) {
        this.saveButton.setVisible(true);
        if (text != null) {
            this.saveButton.setText(text);
        }
        this.saveButton.setOnAction(eventHandler);
    }

    @Override
    protected void doInit() {
        long maxSystemMemory;
        LookupHelper.lookupIfPossible((Node)this.layout, "#exit").ifPresent(b -> b.setOnAction(e -> this.currentStage.close()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#minimize").ifPresent(b -> b.setOnAction(e -> this.currentStage.hide()));
        this.saveButton = (Button)LookupHelper.lookup((Node)this.layout, "#save");
        this.avatar = (ImageView)LookupHelper.lookup((Node)this.layout, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)this.layout, "#avatar").ifPresent(h -> {
            try {
                Rectangle clip = new Rectangle(h.getFitWidth(), h.getFitHeight());
                clip.setArcWidth(h.getFitWidth());
                clip.setArcHeight(h.getFitHeight());
                h.setClip((Node)clip);
                h.setImage(this.originalAvatarImage);
            }
            catch (Throwable e) {
                LogHelper.warning("Skin head error");
            }
        });
        this.componentList = (Pane)((ScrollPane)LookupHelper.lookup((Node)this.layout, "#settingslist")).getContent();
        this.ramSlider = (Slider)LookupHelper.lookup((Node)this.layout, "#ramSlider");
        this.ramLabel = (Label)LookupHelper.lookup((Node)this.layout, "#ramLabel");
        try {
            SystemInfo systemInfo = new SystemInfo();
            maxSystemMemory = systemInfo.getHardware().getMemory().getTotal() >> 20;
        }
        catch (Throwable e2) {
            maxSystemMemory = 2048L;
        }
        this.ramSlider.setMax((double)Math.min(maxSystemMemory, this.getJavaMaxMemory()));
        this.ramSlider.setSnapToTicks(true);
        this.ramSlider.setShowTickMarks(false);
        this.ramSlider.setShowTickLabels(false);
        this.ramSlider.setMinorTickCount(1);
        this.ramSlider.setMajorTickUnit(1024.0);
        this.ramSlider.setBlockIncrement(1024.0);
        this.ramSlider.setLabelFormatter((StringConverter)new StringConverter<Double>(){

            public String toString(Double object) {
                return String.format("%.0fG", object / 1024.0);
            }

            public Double fromString(String string) {
                return null;
            }
        });
        Hyperlink updateDirLink = (Hyperlink)LookupHelper.lookup((Node)this.layout, "#folder", "#path");
        updateDirLink.setText(DirBridge.dirUpdates.toAbsolutePath().toString());
        updateDirLink.setOnAction(e -> this.application.openURL(DirBridge.dirUpdates.toAbsolutePath().toString()));
        ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#changeDir")).setOnAction(e -> {
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle(this.application.getTranslation("runtime.scenes.settings.dirTitle"));
            directoryChooser.setInitialDirectory(DirBridge.dir.toFile());
            File choose = directoryChooser.showDialog((Window)this.application.getMainStage().stage);
            if (choose == null) {
                return;
            }
            Path newDir = choose.toPath().toAbsolutePath();
            try {
                DirBridge.move(newDir);
            }
            catch (IOException ex) {
                this.errorHandle(ex);
            }
            this.application.runtimeSettings.updatesDirPath = newDir.toString();
            this.application.runtimeSettings.updatesDir = newDir;
            String oldDir = DirBridge.dirUpdates.toString();
            DirBridge.dirUpdates = newDir;
            for (ClientProfile profile : this.application.stateService.getProfiles()) {
                RuntimeSettings.ProfileSettings settings = this.application.getProfileSettings(profile);
                if (settings.javaPath == null || !settings.javaPath.startsWith(oldDir)) continue;
                settings.javaPath = newDir.toString().concat(settings.javaPath.substring(oldDir.length()));
            }
            this.application.javaService.update();
            this.javaSelector.reset();
            updateDirLink.setText(this.application.runtimeSettings.updatesDirPath);
        });
        LookupHelper.lookupIfPossible((Node)this.layout, "#back").ifPresent(a -> a.setOnAction(e -> {
            try {
                this.profileSettings = null;
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.reset();
    }

    private long getJavaMaxMemory() {
        if (this.application.javaService.isArchAvailable(JVMHelper.ARCH.X86_64) || this.application.javaService.isArchAvailable(JVMHelper.ARCH.ARM64)) {
            return 32768L;
        }
        return 1536L;
    }

    @Override
    public void reset() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(e -> e.setText(this.application.stateService.getUsername()));
        this.avatar.setImage(this.originalAvatarImage);
        this.profileSettings = new RuntimeSettings.ProfileSettingsView(this.application.getProfileSettings());
        this.javaSelector = new JavaSelectorComponent(this.application.javaService, this.layout, this.profileSettings, this.application.stateService.getProfile());
        this.ramSlider.setValue((double)this.profileSettings.ram);
        this.ramSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.profileSettings.ram = newValue.intValue();
            this.updateRamLabel();
        });
        this.updateRamLabel();
        ServerMenuScene.putAvatarToImageView(this.application, this.application.stateService.getUsername(), this.avatar);
        ClientProfile profile = this.application.stateService.getProfile();
        ServerButtonComponent serverButton = ServerMenuScene.getServerButton(this.application, profile);
        this.enableSaveButton(null, (EventHandler<ActionEvent>)((EventHandler)e -> {
            try {
                this.profileSettings.apply();
                this.application.triggerManager.process(profile, this.application.stateService.getOptionalView());
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.componentList.getChildren().clear();
        this.add("Debug", this.profileSettings.debug, value -> {
            this.profileSettings.debug = value;
        });
        this.add("AutoEnter", this.profileSettings.autoEnter, value -> {
            this.profileSettings.autoEnter = value;
        });
        this.add("Fullscreen", this.profileSettings.fullScreen, value -> {
            this.profileSettings.fullScreen = value;
        });
    }

    @Override
    public String getName() {
        return "settings";
    }

    public void add(String languageName, boolean value, Consumer<Boolean> onChanged) {
        String nameKey = String.format("runtime.scenes.settings.properties.%s.name", languageName.toLowerCase());
        String descriptionKey = String.format("runtime.scenes.settings.properties.%s.description", languageName.toLowerCase());
        this.add(this.application.getTranslation(nameKey, languageName), this.application.getTranslation(descriptionKey, languageName), value, onChanged);
    }

    public void add(String name, String description, boolean value, Consumer<Boolean> onChanged) {
        VBox vBox = new VBox();
        CheckBox checkBox = new CheckBox();
        Label label = new Label();
        vBox.getChildren().add((Object)checkBox);
        vBox.getChildren().add((Object)label);
        vBox.getStyleClass().add((Object)"settings-container");
        checkBox.setSelected(value);
        checkBox.setText(name);
        checkBox.setOnAction(e -> onChanged.accept(checkBox.isSelected()));
        checkBox.getStyleClass().add((Object)"settings-checkbox");
        label.setText(description);
        label.setWrapText(true);
        label.getStyleClass().add((Object)"settings-label");
        this.componentList.getChildren().add((Object)vBox);
    }

    public void updateRamLabel() {
        this.ramLabel.setText(this.profileSettings.ram == 0 ? this.application.getTranslation("runtime.scenes.settings.ramAuto") : MessageFormat.format(this.application.getTranslation("runtime.scenes.settings.ram"), this.profileSettings.ram));
    }
}

