/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.settings;

import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.service.JavaService;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaSelectorComponent {
    private final ComboBox<JavaHelper.JavaVersion> comboBox;
    private final Label javaError;
    private final RuntimeSettings.ProfileSettingsView profileSettings;
    private final ClientProfile profile;
    private final JavaService javaService;

    public JavaSelectorComponent(JavaService javaService, Pane layout, RuntimeSettings.ProfileSettingsView profileSettings, ClientProfile profile) {
        this.comboBox = (ComboBox)LookupHelper.lookup((Node)layout, "#javaCombo");
        this.profile = profile;
        this.comboBox.getItems().clear();
        this.javaError = (Label)LookupHelper.lookup((Node)layout, "#javaError");
        this.profileSettings = profileSettings;
        this.javaService = javaService;
        this.comboBox.setConverter((StringConverter)new JavaVersionConverter(profile));
        this.reset();
    }

    public void reset() {
        JavaHelper.JavaVersion recommend;
        boolean reset = true;
        for (JavaHelper.JavaVersion version : this.javaService.javaVersions) {
            if (this.javaService.isIncompatibleJava(version, this.profile)) continue;
            this.comboBox.getItems().add((Object)version);
            if (this.profileSettings.javaPath == null || !this.profileSettings.javaPath.equals(version.jvmDir.toString())) continue;
            this.comboBox.setValue((Object)version);
            reset = false;
        }
        if (reset && (recommend = this.javaService.getRecommendJavaVersion(this.profile)) != null) {
            LogHelper.warning("Selected Java Version not found. Using %s", recommend.jvmDir.toAbsolutePath().toString());
            this.comboBox.getSelectionModel().select((Object)recommend);
            this.profileSettings.javaPath = recommend.jvmDir.toAbsolutePath().toString();
        }
        this.comboBox.setOnAction(e -> {
            JavaHelper.JavaVersion version = (JavaHelper.JavaVersion)this.comboBox.getValue();
            if (version == null) {
                return;
            }
            LogHelper.info("Select Java %s", version.jvmDir.toAbsolutePath().toString());
        });
    }

    public String getPath() {
        return ((JavaHelper.JavaVersion)this.comboBox.getValue()).jvmDir.toAbsolutePath().toString();
    }

    private static class JavaVersionConverter
    extends StringConverter<JavaHelper.JavaVersion> {
        private final ClientProfile profile;

        private JavaVersionConverter(ClientProfile profile) {
            this.profile = profile;
        }

        public String toString(JavaHelper.JavaVersion object) {
            if (object == null) {
                return "Unknown";
            }
            String postfix = "";
            if (object.version == this.profile.getRecommendJavaVersion()) {
                postfix = "[RECOMMENDED]";
            }
            return String.format("Java %d b%d %s", object.version, object.build, postfix);
        }

        public JavaHelper.JavaVersion fromString(String string) {
            return null;
        }
    }
}

