/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.servermenu;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import pro.gravit.launcher.client.ServerPinger;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerButtonComponent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;

public class ServerMenuScene
extends AbstractScene {
    private static final String SERVER_BUTTON_FXML = "components/serverButton.fxml";
    private static final String SERVER_BUTTON_CUSTOM_FXML = "components/serverButton/%s.fxml";
    private ImageView avatar;
    private List<ClientProfile> lastProfiles;
    private Image originalAvatarImage;

    public ServerMenuScene(JavaFXApplication application) {
        super("scenes/servermenu/servermenu.fxml", application);
    }

    @Override
    public void doInit() throws Exception {
        LookupHelper.lookupIfPossible((Node)this.layout, "#exit").ifPresent(b -> b.setOnAction(e -> this.currentStage.close()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#minimize").ifPresent(b -> b.setOnAction(e -> this.currentStage.hide()));
        this.avatar = (ImageView)LookupHelper.lookup((Node)this.layout, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)this.layout, "#avatar").ifPresent(h -> {
            try {
                Rectangle clip = new Rectangle(h.getFitWidth(), h.getFitHeight());
                clip.setArcWidth(h.getFitWidth());
                clip.setArcHeight(h.getFitHeight());
                h.setClip((Node)clip);
                h.setImage(this.originalAvatarImage);
            }
            catch (Throwable e) {
                LogHelper.warning("Skin head error");
            }
        });
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        scrollPane.setOnScroll(e -> {
            double offset = e.getDeltaY() / scrollPane.getWidth();
            scrollPane.setHvalue(scrollPane.getHvalue() - offset);
        });
        this.reset();
        this.isResetOnShow = true;
    }

    public static boolean putAvatarToImageView(JavaFXApplication application, String username, ImageView imageView) {
        int height;
        int width = (int)imageView.getFitWidth();
        Image head = application.skinManager.getScaledFxSkinHead(username, width, height = (int)imageView.getFitHeight());
        if (head == null) {
            return false;
        }
        imageView.setImage(head);
        return true;
    }

    public static ServerButtonComponent getServerButton(JavaFXApplication application, ClientProfile profile) {
        return new ServerButtonComponent(application, profile);
    }

    @Override
    public void reset() {
        if (this.lastProfiles == this.application.stateService.getProfiles()) {
            return;
        }
        this.lastProfiles = this.application.stateService.getProfiles();
        LinkedHashMap<ClientProfile, ServerButtonCache> serverButtonCacheMap = new LinkedHashMap<ClientProfile, ServerButtonCache>();
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(e -> e.setText(this.application.stateService.getUsername()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#role").ifPresent(e -> e.setText(this.application.stateService.getMainRole()));
        this.avatar.setImage(this.originalAvatarImage);
        ArrayList<ClientProfile> profiles = new ArrayList<ClientProfile>(this.lastProfiles);
        profiles.sort(Comparator.comparingInt(ClientProfile::getSortIndex).thenComparing(ClientProfile::getTitle));
        int position = 0;
        for (ClientProfile profile2 : profiles) {
            ServerButtonCache cache = new ServerButtonCache();
            cache.serverButton = ServerMenuScene.getServerButton(this.application, profile2);
            cache.position = position++;
            serverButtonCacheMap.put(profile2, cache);
            profile2.updateOptionalGraph();
        }
        ScrollPane scrollPane = (ScrollPane)LookupHelper.lookup((Node)this.layout, "#servers");
        HBox serverList = (HBox)scrollPane.getContent();
        serverList.setSpacing(20.0);
        serverList.getChildren().clear();
        this.application.pingService.clear();
        serverButtonCacheMap.forEach((profile, serverButtonCache) -> {
            EventHandler handle = event -> {
                if (!event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    return;
                }
                this.changeServer((ClientProfile)profile);
                try {
                    this.switchScene(this.application.gui.serverInfoScene);
                    this.application.gui.serverInfoScene.reset();
                }
                catch (Exception e) {
                    this.errorHandle(e);
                }
            };
            serverButtonCache.serverButton.addTo((Pane)serverList, serverButtonCache.position);
            serverButtonCache.serverButton.setOnMouseClicked((EventHandler<? super MouseEvent>)handle);
        });
        CommonHelper.newThread("ServerPinger", true, () -> {
            for (ClientProfile profile : this.lastProfiles) {
                for (ClientProfile.ServerProfile serverProfile : profile.getServers()) {
                    if (!serverProfile.socketPing || serverProfile.serverAddress == null) continue;
                    try {
                        ServerPinger pinger = new ServerPinger(serverProfile, profile.getVersion());
                        ServerPinger.Result result = pinger.ping();
                        this.contextHelper.runInFxThread(() -> this.application.pingService.addReport(serverProfile.name, result));
                    }
                    catch (IOException iOException) {}
                }
            }
        }).start();
        ServerMenuScene.putAvatarToImageView(this.application, this.application.stateService.getUsername(), this.avatar);
    }

    @Override
    public String getName() {
        return "serverMenu";
    }

    private void changeServer(ClientProfile profile) {
        this.application.stateService.setProfile(profile);
        this.application.runtimeSettings.lastProfile = profile.getUUID();
    }

    static class ServerButtonCache {
        public ServerButtonComponent serverButton;
        public int position;

        ServerButtonCache() {
        }
    }
}

