/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.servermenu;

import java.net.URL;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.utils.helper.LogHelper;

public class ServerButtonComponent
extends AbstractVisualComponent {
    private static final String SERVER_BUTTON_FXML = "components/serverButton.fxml";
    private static final String SERVER_BUTTON_CUSTOM_FXML = "components/serverButton/%s.fxml";
    public ClientProfile profile;
    private Button saveButton;
    private Button resetButton;

    protected ServerButtonComponent(JavaFXApplication application, ClientProfile profile) {
        super(ServerButtonComponent.getFXMLPath(application, profile), application);
        this.profile = profile;
    }

    private static String getFXMLPath(JavaFXApplication application, ClientProfile profile) {
        String customFxmlName = String.format(SERVER_BUTTON_CUSTOM_FXML, profile.getUUID());
        URL customFxml = application.tryResource(customFxmlName);
        if (customFxml != null) {
            return customFxmlName;
        }
        return SERVER_BUTTON_FXML;
    }

    @Override
    public String getName() {
        return "serverButton";
    }

    @Override
    protected void doInit() throws Exception {
        ((Labeled)LookupHelper.lookup((Node)this.layout, "#nameServer")).setText(this.profile.getTitle());
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverLogo").ifPresent(a -> {
            try {
                Rectangle clip = new Rectangle(a.getFitWidth(), a.getFitHeight());
                clip.setArcWidth(24.0);
                clip.setArcHeight(24.0);
                a.setClip((Node)clip);
            }
            catch (Throwable e) {
                LogHelper.error(e);
            }
        });
    }

    public void setOnMouseClicked(EventHandler<? super MouseEvent> eventHandler) {
        ((Button)LookupHelper.lookup((Node)this.layout, "#next")).setOnMouseClicked(eventHandler);
    }

    public void addTo(Pane pane) {
        if (!this.isInit()) {
            try {
                this.init();
            }
            catch (Exception e) {
                LogHelper.error(e);
            }
        }
        pane.getChildren().add((Object)this.layout);
    }

    public void addTo(Pane pane, int position) {
        if (!this.isInit()) {
            try {
                this.init();
            }
            catch (Exception e) {
                LogHelper.error(e);
            }
        }
        pane.getChildren().add(position, (Object)this.layout);
    }

    @Override
    public void reset() {
    }

    @Override
    public void disable() {
    }

    @Override
    public void enable() {
    }
}

