/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.serverinfo;

import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Labeled;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.shape.Rectangle;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.ClientLauncherProcess;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.debug.DebugScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.hasher.HashedDir;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.ClientProfileVersions;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.launcher.request.auth.SetProfileRequest;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class ServerInfoScene
extends AbstractScene {
    private ImageView avatar;
    private Image originalAvatarImage;

    public ServerInfoScene(JavaFXApplication application) {
        super("scenes/serverinfo/serverinfo.fxml", application);
    }

    @Override
    protected void doInit() throws Exception {
        LookupHelper.lookupIfPossible((Node)this.layout, "#exit").ifPresent(b -> b.setOnAction(e -> this.currentStage.close()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#minimize").ifPresent(b -> b.setOnAction(e -> this.currentStage.hide()));
        this.avatar = (ImageView)LookupHelper.lookup((Node)this.layout, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)this.layout, "#avatar").ifPresent(h -> {
            try {
                Rectangle clip = new Rectangle(h.getFitWidth(), h.getFitHeight());
                clip.setArcWidth(h.getFitWidth());
                clip.setArcHeight(h.getFitHeight());
                h.setClip((Node)clip);
                h.setImage(this.originalAvatarImage);
            }
            catch (Throwable e) {
                LogHelper.warning("Skin head error");
            }
        });
        ((Button)LookupHelper.lookup((Node)this.layout, "#back")).setOnAction(e -> {
            try {
                this.switchScene(this.application.gui.serverMenuScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#settings")).setOnAction(e -> {
            try {
                this.switchScene(this.application.gui.settingsScene);
                this.application.gui.settingsScene.reset();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#clientSettings")).setOnAction(e -> {
            try {
                if (this.application.stateService.getProfile() == null) {
                    return;
                }
                this.switchScene(this.application.gui.optionsScene);
                this.application.gui.optionsScene.reset();
                this.application.gui.optionsScene.addProfileOptionals(this.application.stateService.getOptionalView());
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        });
        ((Button)LookupHelper.lookup((Node)this.layout, "#play")).setOnAction(e -> {
            try {
                this.launchClient();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        });
        this.reset();
    }

    @Override
    public void reset() {
        this.avatar.setImage(this.originalAvatarImage);
        ClientProfile profile = this.application.stateService.getProfile();
        LookupHelper.lookupIfPossible((Node)this.layout, "#serverDescription").ifPresent(e -> e.setText(profile.getInfo()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(e -> e.setText(this.application.stateService.getUsername()));
        ServerMenuScene.putAvatarToImageView(this.application, this.application.stateService.getUsername(), this.avatar);
        AtomicLong currentOnline = new AtomicLong(0L);
        AtomicLong maxOnline = new AtomicLong(0L);
        Runnable update = () -> this.contextHelper.runInFxThread(() -> {
            if (currentOnline.get() == 0L && maxOnline.get() == 0L) {
                ((Labeled)LookupHelper.lookup((Node)this.layout, "#onlineblyaty")).setText("\u0421\u0435\u0440\u0432\u0435\u0440 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d");
            } else {
                ((Labeled)LookupHelper.lookup((Node)this.layout, "#onlineblyaty")).setText("\u0418\u0433\u0440\u043e\u043a\u043e\u0432 \u0432 \u0441\u0435\u0442\u0438: " + currentOnline.get());
            }
        });
        for (ClientProfile.ServerProfile serverProfile : profile.getServers()) {
            this.application.pingService.getPingReport(serverProfile.name).thenAccept(report -> {
                if (report != null) {
                    currentOnline.addAndGet(report.playersOnline);
                    maxOnline.addAndGet(report.maxPlayers);
                }
                update.run();
            });
        }
    }

    @Override
    public String getName() {
        return null;
    }

    private void downloadClients(ClientProfile profile, JavaHelper.JavaVersion javaVersion, HashedDir jvmHDir) {
        Path target = DirBridge.dirUpdates.resolve(profile.getAssetDir());
        LogHelper.info("Start update to %s", target.toString());
        Consumer<HashedDir> next = assetHDir -> {
            Path targetClient = DirBridge.dirUpdates.resolve(profile.getDir());
            LogHelper.info("Start update to %s", targetClient.toString());
            this.application.gui.updateScene.sendUpdateRequest(profile.getDir(), targetClient, profile.getClientUpdateMatcher(), true, this.application.stateService.getOptionalView(), true, clientHDir -> {
                LogHelper.info("Success update");
                try {
                    this.doLaunchClient(target, (HashedDir)assetHDir, targetClient, (HashedDir)clientHDir, profile, this.application.stateService.getOptionalView(), javaVersion, jvmHDir);
                }
                catch (Throwable e) {
                    LogHelper.error(e);
                    ContextHelper.runInFxThreadStatic(() -> this.application.gui.updateScene.addLog(String.format("launchClient error %s:%s", e.getClass().getName(), e.getMessage())));
                }
            });
        };
        if (profile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_6_4) <= 0) {
            this.application.gui.updateScene.sendUpdateRequest(profile.getAssetDir(), target, profile.getAssetUpdateMatcher(), true, null, false, next);
        } else {
            this.application.gui.updateScene.sendUpdateAssetRequest(profile.getAssetDir(), target, profile.getAssetUpdateMatcher(), true, profile.getAssetIndex(), next);
        }
    }

    private void doLaunchClient(Path assetDir, HashedDir assetHDir, Path clientDir, HashedDir clientHDir, ClientProfile profile, OptionalView view, JavaHelper.JavaVersion javaVersion, HashedDir jvmHDir) {
        RuntimeSettings.ProfileSettings profileSettings = this.application.getProfileSettings();
        if (javaVersion == null) {
            javaVersion = this.application.javaService.getRecommendJavaVersion(profile);
        }
        if (javaVersion == null) {
            javaVersion = JavaHelper.JavaVersion.getCurrentJavaVersion();
        }
        ClientLauncherProcess clientLauncherProcess = new ClientLauncherProcess(clientDir, assetDir, javaVersion, clientDir.resolve("resourcepacks"), profile, this.application.stateService.getPlayerProfile(), view, this.application.stateService.getAccessToken(), clientHDir, assetHDir, jvmHDir);
        clientLauncherProcess.params.ram = profileSettings.ram;
        clientLauncherProcess.params.offlineMode = this.application.offlineService.isOfflineMode();
        if (clientLauncherProcess.params.ram > 0) {
            clientLauncherProcess.jvmArgs.add("-Xms" + clientLauncherProcess.params.ram + 'M');
            clientLauncherProcess.jvmArgs.add("-Xmx" + clientLauncherProcess.params.ram + 'M');
        }
        clientLauncherProcess.params.fullScreen = profileSettings.fullScreen;
        clientLauncherProcess.params.autoEnter = profileSettings.autoEnter;
        this.contextHelper.runCallback(() -> {
            Thread writerThread = CommonHelper.newThread("Client Params Writer Thread", true, () -> {
                block3: {
                    try {
                        clientLauncherProcess.runWriteParams(new InetSocketAddress("127.0.0.1", Launcher.getConfig().clientPort));
                        if (!profileSettings.debug) {
                            LogHelper.debug("Params writted successful. Exit...");
                            LauncherEngine.exitLauncher(0);
                        }
                    }
                    catch (Throwable e) {
                        LogHelper.error(e);
                        if (!(this.getCurrentStage().getVisualComponent() instanceof DebugScene)) break block3;
                        DebugScene debugScene = (DebugScene)this.getCurrentStage().getVisualComponent();
                        debugScene.append(String.format("Launcher fatal error(Write Params Thread): %s: %s", e.getClass().getName(), e.getMessage()));
                        if (debugScene.currentProcess == null || !debugScene.currentProcess.isAlive()) break block3;
                        debugScene.currentProcess.destroy();
                    }
                }
            });
            writerThread.start();
            this.application.gui.debugScene.writeParametersThread = writerThread;
            clientLauncherProcess.start(true);
            this.contextHelper.runInFxThread(() -> {
                this.switchScene(this.application.gui.debugScene);
                this.application.gui.debugScene.onProcess(clientLauncherProcess.getProcess());
            });
        });
    }

    private String getJavaDirName(Path javaPath) {
        String prefix = DirBridge.dirUpdates.toAbsolutePath().toString();
        if (javaPath == null || !javaPath.startsWith(prefix)) {
            return null;
        }
        Path result = DirBridge.dirUpdates.relativize(javaPath);
        return result.toString();
    }

    private void showJavaAlert(ClientProfile profile) {
        if ((JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM32 || JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64) && profile.getVersion().compareTo(ClientProfileVersions.MINECRAFT_1_12_2) <= 0) {
            this.application.messageManager.showDialog(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.lwjgl2.header"), String.format(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.lwjgl2.description"), profile.getRecommendJavaVersion()), () -> {}, () -> {}, true);
        } else {
            this.application.messageManager.showDialog(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.header"), String.format(this.application.getTranslation("runtime.scenes.serverinfo.javaalert.description"), profile.getRecommendJavaVersion()), () -> {}, () -> {}, true);
        }
    }

    private void launchClient() {
        ClientProfile profile = this.application.stateService.getProfile();
        if (profile == null) {
            return;
        }
        this.processRequest(this.application.getTranslation("runtime.overlay.processing.text.setprofile"), new SetProfileRequest(profile), result -> this.contextHelper.runInFxThread(() -> this.hideOverlay(0.0, (EventHandler<ActionEvent>)((EventHandler)ev -> {
            RuntimeSettings.ProfileSettings profileSettings = this.application.getProfileSettings();
            JavaHelper.JavaVersion javaVersion = null;
            for (JavaHelper.JavaVersion v : this.application.javaService.javaVersions) {
                if (!v.jvmDir.toAbsolutePath().toString().equals(profileSettings.javaPath)) continue;
                javaVersion = v;
            }
            if (javaVersion == null && profileSettings.javaPath != null && !this.application.guiModuleConfig.forceDownloadJava) {
                try {
                    javaVersion = JavaHelper.JavaVersion.getByPath(Paths.get(profileSettings.javaPath, new String[0]));
                }
                catch (Throwable e) {
                    if (LogHelper.isDevEnabled()) {
                        LogHelper.error(e);
                    }
                    LogHelper.warning("Incorrect java path %s", profileSettings.javaPath);
                }
            }
            if (javaVersion == null || this.application.javaService.isIncompatibleJava(javaVersion, profile)) {
                javaVersion = this.application.javaService.getRecommendJavaVersion(profile);
            }
            if (javaVersion == null) {
                this.showJavaAlert(profile);
                return;
            }
            String jvmDirName = this.getJavaDirName(javaVersion.jvmDir);
            if (jvmDirName != null) {
                JavaHelper.JavaVersion finalJavaVersion = javaVersion;
                try {
                    this.switchScene(this.application.gui.updateScene);
                }
                catch (Exception e) {
                    this.errorHandle(e);
                }
                this.application.gui.updateScene.sendUpdateRequest(jvmDirName, javaVersion.jvmDir, null, true, this.application.stateService.getOptionalView(), false, jvmHDir -> {
                    Path javaFile;
                    if ((JVMHelper.OS_TYPE == JVMHelper.OS.LINUX || JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX) && Files.exists(javaFile = finalJavaVersion.jvmDir.resolve("bin").resolve("java"), new LinkOption[0]) && !javaFile.toFile().setExecutable(true)) {
                        LogHelper.warning("Set permission for %s unsuccessful", javaFile.toString());
                    }
                    this.downloadClients(profile, finalJavaVersion, (HashedDir)jvmHDir);
                });
            } else {
                try {
                    this.switchScene(this.application.gui.updateScene);
                }
                catch (Exception e) {
                    this.errorHandle(e);
                }
                this.downloadClients(profile, javaVersion, null);
            }
        }))), null);
    }
}

