/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.options;

import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.optional.OptionalFile;
import pro.gravit.launcher.profiles.optional.OptionalView;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class OptionsScene
extends AbstractScene {
    private Pane componentList;
    private OptionalView optionalView;
    private ImageView avatar;
    private Image originalAvatarImage;
    private Button saveButton;
    private final Map<OptionalFile, Consumer<Boolean>> watchers = new HashMap<OptionalFile, Consumer<Boolean>>();

    public OptionsScene(JavaFXApplication application) {
        super("scenes/options/options.fxml", application);
    }

    public void enableSaveButton(String text, EventHandler<ActionEvent> eventHandler) {
        this.saveButton.setVisible(true);
        if (text != null) {
            this.saveButton.setText(text);
        }
        this.saveButton.setOnAction(eventHandler);
    }

    @Override
    protected void doInit() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#exit").ifPresent(b -> b.setOnAction(e -> this.currentStage.close()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#minimize").ifPresent(b -> b.setOnAction(e -> this.currentStage.hide()));
        this.avatar = (ImageView)LookupHelper.lookup((Node)this.layout, "#avatar");
        this.originalAvatarImage = this.avatar.getImage();
        LookupHelper.lookupIfPossible((Node)this.layout, "#avatar").ifPresent(h -> {
            try {
                Rectangle clip = new Rectangle(h.getFitWidth(), h.getFitHeight());
                clip.setArcWidth(h.getFitWidth());
                clip.setArcHeight(h.getFitHeight());
                h.setClip((Node)clip);
                h.setImage(this.originalAvatarImage);
            }
            catch (Throwable e) {
                LogHelper.warning("Skin head error");
            }
        });
        this.componentList = (Pane)((ScrollPane)LookupHelper.lookup((Node)this.layout, "#optionslist")).getContent();
        this.saveButton = (Button)LookupHelper.lookup((Node)this.layout, "#save");
    }

    @Override
    public void reset() {
        this.avatar.setImage(this.originalAvatarImage);
        ClientProfile profile = this.application.stateService.getProfile();
        LookupHelper.lookupIfPossible((Node)this.layout, "#nickname").ifPresent(e -> e.setText(this.application.stateService.getUsername()));
        this.componentList.getChildren().clear();
        LookupHelper.lookupIfPossible((Node)this.layout, "#back").ifPresent(x -> x.setOnAction(e -> {
            try {
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.enableSaveButton(null, (EventHandler<ActionEvent>)((EventHandler)e -> {
            try {
                this.application.stateService.setOptionalView(profile, this.optionalView);
                this.switchScene(this.application.gui.serverInfoScene);
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        ServerMenuScene.putAvatarToImageView(this.application, this.application.stateService.getUsername(), this.avatar);
    }

    @Override
    public String getName() {
        return "options";
    }

    private void callWatcher(OptionalFile file, Boolean value) {
        for (Map.Entry<OptionalFile, Consumer<Boolean>> v : this.watchers.entrySet()) {
            if (v.getKey() != file) continue;
            v.getValue().accept(value);
            break;
        }
    }

    public void addProfileOptionals(OptionalView view) {
        this.optionalView = new OptionalView(view);
        this.watchers.clear();
        for (OptionalFile optionalFile : this.optionalView.all) {
            if (!optionalFile.visible) continue;
            Consumer<Boolean> setCheckBox = this.add(optionalFile.name, optionalFile.info, this.optionalView.enabled.contains(optionalFile), optionalFile.subTreeLevel, isSelected -> {
                if (isSelected.booleanValue()) {
                    this.optionalView.enable(optionalFile, true, this::callWatcher);
                } else {
                    this.optionalView.disable(optionalFile, this::callWatcher);
                }
            });
            this.watchers.put(optionalFile, setCheckBox);
        }
    }

    public Consumer<Boolean> add(String name, String description, boolean value, int padding, Consumer<Boolean> onChanged) {
        VBox vBox = new VBox();
        CheckBox checkBox = new CheckBox();
        Label label = new Label();
        vBox.getChildren().add((Object)checkBox);
        vBox.getChildren().add((Object)label);
        VBox.setMargin((Node)vBox, (Insets)new Insets(0.0, 0.0, 0.0, (double)(30 * --padding)));
        vBox.getStyleClass().add((Object)"optional-container");
        checkBox.setSelected(value);
        checkBox.setText(name);
        checkBox.setOnAction(e -> onChanged.accept(checkBox.isSelected()));
        checkBox.getStyleClass().add((Object)"optional-checkbox");
        label.setText(description);
        label.setWrapText(true);
        label.getStyleClass().add((Object)"optional-label");
        this.componentList.getChildren().add((Object)vBox);
        return arg_0 -> ((CheckBox)checkBox).setSelected(arg_0);
    }

    public void saveAll() throws IOException {
        List<ClientProfile> profiles = this.application.stateService.getProfiles();
        Map<ClientProfile, OptionalView> optionalViewMap = this.application.stateService.getOptionalViewMap();
        if (profiles == null) {
            return;
        }
        Path optionsFile = DirBridge.dir.resolve("options.json");
        ArrayList<OptionalListEntry> list = new ArrayList<OptionalListEntry>(5);
        for (ClientProfile clientProfile : profiles) {
            OptionalListEntry entry = new OptionalListEntry();
            entry.name = clientProfile.getTitle();
            entry.profileUUID = clientProfile.getUUID();
            OptionalView view = optionalViewMap.get(clientProfile);
            view.all.forEach(optionalFile -> {
                if (optionalFile.visible) {
                    boolean isEnabled = view.enabled.contains(optionalFile);
                    OptionalView.OptionalFileInstallInfo installInfo = view.installInfo.get(optionalFile);
                    entry.enabled.add(new OptionalListEntryPair((OptionalFile)optionalFile, isEnabled, installInfo));
                }
            });
            list.add(entry);
        }
        try (BufferedWriter writer = IOHelper.newWriter(optionsFile);){
            Launcher.gsonManager.gson.toJson(list, (Appendable)writer);
        }
    }

    public void loadAll() throws IOException {
        List<ClientProfile> profiles = this.application.stateService.getProfiles();
        Map<ClientProfile, OptionalView> optionalViewMap = this.application.stateService.getOptionalViewMap();
        if (profiles == null) {
            return;
        }
        Path optionsFile = DirBridge.dir.resolve("options.json");
        if (!Files.exists(optionsFile, new LinkOption[0])) {
            return;
        }
        Type collectionType = new TypeToken<List<OptionalListEntry>>(){}.getType();
        try (BufferedReader reader = IOHelper.newReader(optionsFile);){
            List list = (List)Launcher.gsonManager.gson.fromJson((Reader)reader, collectionType);
            for (OptionalListEntry entry : list) {
                ClientProfile selectedProfile = null;
                for (ClientProfile clientProfile : profiles) {
                    if (!(entry.profileUUID != null ? entry.profileUUID.equals(clientProfile.getUUID()) : clientProfile.getTitle().equals(entry.name))) continue;
                    selectedProfile = clientProfile;
                }
                if (selectedProfile == null) {
                    LogHelper.warning("Optional: profile %s(%s) not found", entry.name, entry.profileUUID);
                    continue;
                }
                OptionalView view = optionalViewMap.get(selectedProfile);
                for (OptionalListEntryPair entryPair : entry.enabled) {
                    try {
                        OptionalFile file = selectedProfile.getOptionalFile(entryPair.name);
                        if (!file.visible) continue;
                        if (entryPair.mark) {
                            view.enable(file, entryPair.installInfo != null && entryPair.installInfo.isManual, null);
                            continue;
                        }
                        view.disable(file, null);
                    }
                    catch (Exception exc) {
                        LogHelper.warning("Optional: in profile %s markOptional mod %s failed", selectedProfile.getTitle(), entryPair.name);
                    }
                }
            }
        }
    }

    public static class OptionalListEntry {
        public List<OptionalListEntryPair> enabled = new LinkedList<OptionalListEntryPair>();
        public String name;
        public UUID profileUUID;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OptionalListEntry that = (OptionalListEntry)o;
            return Objects.equals(this.profileUUID, that.profileUUID) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.profileUUID);
        }
    }

    public static class OptionalListEntryPair {
        public String name;
        public boolean mark;
        public OptionalView.OptionalFileInstallInfo installInfo;

        public OptionalListEntryPair(OptionalFile optionalFile, boolean enabled, OptionalView.OptionalFileInstallInfo installInfo) {
            this.name = optionalFile.name;
            this.mark = enabled;
            this.installInfo = installInfo;
        }
    }
}

