/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.login.methods;

import java.util.concurrent.CompletableFuture;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.scenes.login.LoginAuthButtonComponent;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.login.methods.AbstractAuthMethod;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.details.AuthPasswordDetails;

public class LoginAndPasswordAuthMethod
extends AbstractAuthMethod<AuthPasswordDetails> {
    private final LoginAndPasswordOverlay overlay;
    private final JavaFXApplication application;
    private final LoginScene.LoginSceneAccessor accessor;

    public LoginAndPasswordAuthMethod(LoginScene.LoginSceneAccessor accessor) {
        this.accessor = accessor;
        this.application = accessor.getApplication();
        this.overlay = this.application.gui.registerOverlay(LoginAndPasswordOverlay.class);
        this.overlay.accessor = accessor;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void reset() {
        this.overlay.reset();
    }

    @Override
    public CompletableFuture<Void> show(AuthPasswordDetails details) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.accessor.showOverlay(this.overlay, (EventHandler<ActionEvent>)((EventHandler)e -> future.complete(null)));
        }
        catch (Exception e2) {
            this.accessor.errorHandle(e2);
        }
        return future;
    }

    @Override
    public CompletableFuture<LoginScene.LoginAndPasswordResult> auth(AuthPasswordDetails details) {
        this.overlay.future = new CompletableFuture();
        String login = this.overlay.login.getText();
        if (this.overlay.password.getText().isEmpty() && this.overlay.password.getPromptText().equals(this.application.getTranslation("runtime.scenes.login.password.saved"))) {
            AuthRequest.AuthPasswordInterface password = this.application.runtimeSettings.password;
            return CompletableFuture.completedFuture(new LoginScene.LoginAndPasswordResult(login, password));
        }
        return this.overlay.future;
    }

    @Override
    public CompletableFuture<Void> hide() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.accessor.hideOverlay(0.0, (EventHandler<ActionEvent>)((EventHandler)e -> future.complete(null)));
        return future;
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    public static class LoginAndPasswordOverlay
    extends AbstractOverlay {
        private static final AbstractAuthMethod.UserAuthCanceledException USER_AUTH_CANCELED_EXCEPTION = new AbstractAuthMethod.UserAuthCanceledException();
        private TextField login;
        private TextField password;
        private LoginAuthButtonComponent authButton;
        private LoginScene.LoginSceneAccessor accessor;
        private CompletableFuture<LoginScene.LoginAndPasswordResult> future;

        public LoginAndPasswordOverlay(JavaFXApplication application) {
            super("scenes/login/loginpassword.fxml", application);
        }

        @Override
        public String getName() {
            return "loginandpassword";
        }

        @Override
        protected void doInit() {
            LookupHelper.lookupIfPossible((Node)this.layout, "#exit").ifPresent(b -> b.setOnAction(e -> this.currentStage.close()));
            LookupHelper.lookupIfPossible((Node)this.layout, "#minimize").ifPresent(b -> b.setOnAction(e -> this.currentStage.hide()));
            this.login = (TextField)LookupHelper.lookup((Node)this.layout, "#login");
            this.password = (TextField)LookupHelper.lookup((Node)this.layout, "#password");
            this.authButton = new LoginAuthButtonComponent((Pane)LookupHelper.lookup((Node)this.layout, "#authButtonBlock"), this.application, (EventHandler<ActionEvent>)((EventHandler)e -> {
                String rawLogin = this.login.getText();
                String rawPassword = this.password.getText();
                this.future.complete(new LoginScene.LoginAndPasswordResult(rawLogin, this.accessor.getAuthService().makePassword(rawPassword)));
            }));
            if (this.application.guiModuleConfig.createAccountURL != null) {
                ((Button)LookupHelper.lookup((Node)this.layout, "#createAccount")).setOnMouseClicked(e -> this.application.openURL(this.application.guiModuleConfig.createAccountURL));
            }
            if (this.application.guiModuleConfig.forgotPassURL != null) {
                ((Button)LookupHelper.lookup((Node)this.layout, "#forgotPass")).setOnMouseClicked(e -> this.application.openURL(this.application.guiModuleConfig.forgotPassURL));
            }
            if (this.application.runtimeSettings.password != null) {
                this.password.getStyleClass().add((Object)"hasSaved");
                this.password.setPromptText(this.application.getTranslation("runtime.scenes.login.password.saved"));
            }
        }

        @Override
        public void reset() {
            if (this.password == null) {
                return;
            }
            this.password.getStyleClass().removeAll((Object[])new String[]{"hasSaved"});
            this.password.setPromptText(this.application.getTranslation("runtime.scenes.login.password"));
            this.password.setText("");
            this.login.setText("");
        }
    }
}

