/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes.debug;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javafx.scene.Node;
import javafx.scene.control.TextArea;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class DebugScene
extends AbstractScene {
    private static final long MAX_LENGTH = 32768L;
    private static final int REMOVE_LENGTH = 4096;
    public Process currentProcess;
    public Thread writeParametersThread;
    private Thread readThread;
    private TextArea output;
    private final Object syncObject = new Object();
    private String appendString = "";
    private boolean isOutputRunned;

    public DebugScene(JavaFXApplication application) {
        super("scenes/debug/debug.fxml", application);
        this.isResetOnShow = true;
    }

    @Override
    protected void doInit() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#exit").ifPresent(b -> b.setOnAction(e -> this.currentStage.close()));
        LookupHelper.lookupIfPossible((Node)this.layout, "#minimize").ifPresent(b -> b.setOnAction(e -> this.currentStage.hide()));
        this.output = (TextArea)LookupHelper.lookup((Node)this.layout, "#output");
    }

    @Override
    public void reset() {
        this.output.clear();
    }

    public void onProcess(Process process) {
        if (this.readThread != null && this.readThread.isAlive()) {
            this.readThread.interrupt();
            try {
                this.readThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.currentProcess != null && this.currentProcess.isAlive()) {
            this.currentProcess.destroyForcibly();
        }
        this.readThread = CommonHelper.newThread("Client Process Console Reader", true, () -> {
            BufferedInputStream stream = new BufferedInputStream(process.getInputStream());
            byte[] buf = IOHelper.newBuffer();
            try {
                int length = ((InputStream)stream).read(buf);
                while (length >= 0) {
                    this.append(new String(buf, 0, length));
                    length = ((InputStream)stream).read(buf);
                }
                if (this.currentProcess.isAlive()) {
                    this.currentProcess.waitFor();
                }
                this.onProcessExit(this.currentProcess.exitValue());
            }
            catch (IOException e) {
                this.errorHandle(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.readThread.start();
        this.currentProcess = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String text) {
        boolean needRun = false;
        Object object = this.syncObject;
        synchronized (object) {
            this.appendString = (long)this.appendString.length() > 32768L ? "<logs buffer overflow>\n".concat(text) : this.appendString.concat(text);
            if (!this.isOutputRunned) {
                needRun = true;
                this.isOutputRunned = true;
            }
        }
        if (needRun) {
            ContextHelper.runInFxThreadStatic(() -> {
                Object object = this.syncObject;
                synchronized (object) {
                    if ((long)this.output.lengthProperty().get() > 32768L) {
                        this.output.deleteText(0, 4096);
                    }
                    this.output.appendText(this.appendString);
                    this.appendString = "";
                    this.isOutputRunned = false;
                }
            });
        }
    }

    @Override
    public void errorHandle(Throwable e) {
        if (!(e instanceof EOFException) && LogHelper.isDebugEnabled()) {
            this.append(e.toString());
        }
        if (this.currentProcess != null && !this.currentProcess.isAlive()) {
            this.onProcessExit(this.currentProcess.exitValue());
        }
    }

    @Override
    public String getName() {
        return "debug";
    }

    private void onProcessExit(int code) {
        this.append(String.format("Process exit code %d", code));
        if (this.writeParametersThread != null) {
            this.writeParametersThread.interrupt();
        }
    }

    public String hastebin(String log) throws IOException {
        if (this.application.guiModuleConfig.hastebinServer == null) {
            throw new NullPointerException("Regenerate the config \"JavaRuntime.json\"");
        }
        URL url = new URL(this.application.guiModuleConfig.hastebinServer + "/documents");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        connection.setRequestProperty("Accept", "application/json");
        connection.addRequestProperty("User-Agent", "Mozilla/4.76");
        connection.setConnectTimeout(10000);
        try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);){
            writer.write(log);
            writer.flush();
        }
        int statusCode = connection.getResponseCode();
        InputStreamReader reader = 200 <= statusCode && statusCode < 300 ? new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8) : new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8);
        try {
            HasteResponse obj = Launcher.gsonManager.gson.fromJson((Reader)reader, HasteResponse.class);
            this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.debug.hastebin.success.header"), this.application.getTranslation("runtime.overlay.debug.hastebin.success.description"));
            return this.application.guiModuleConfig.hastebinServer + "/" + obj.key;
        }
        catch (Exception e) {
            if (200 > statusCode || statusCode > 300) {
                this.application.messageManager.createNotification(this.application.getTranslation("runtime.overlay.debug.hastebin.fail.header"), this.application.getTranslation("runtime.overlay.debug.hastebin.fail.description"));
                LogHelper.error("JsonRequest failed. Server response code %d", statusCode);
                throw new IOException(e);
            }
            return null;
        }
    }

    public static class HasteResponse {
        @LauncherNetworkAPI
        public String key;
    }
}

