/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.scenes;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.config.RuntimeSettings;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.AbstractStage;
import pro.gravit.launcher.client.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launcher.request.auth.ExitRequest;
import pro.gravit.utils.helper.LogHelper;

public abstract class AbstractScene
extends AbstractVisualComponent {
    protected final LauncherConfig launcherConfig;
    protected Scene scene;
    protected Pane header;
    protected Pane disablePane;
    private volatile Node currentOverlayNode;
    private volatile AbstractOverlay currentOverlay;
    private AtomicInteger enabled = new AtomicInteger(0);
    private volatile boolean hideTransformStarted = false;

    protected AbstractScene(String fxmlPath, JavaFXApplication application) {
        super(fxmlPath, application);
        this.launcherConfig = Launcher.getConfig();
    }

    protected AbstractStage getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public void init() throws Exception {
        if (this.scene == null) {
            this.scene = new Scene(this.getFxmlRoot());
            this.scene.setFill((Paint)Color.TRANSPARENT);
        }
        this.layout = (Pane)LookupHelper.lookupIfPossible((Node)this.scene.getRoot(), "#layout").orElse(this.scene.getRoot());
        Rectangle rect = new Rectangle(this.layout.getPrefWidth(), this.layout.getPrefHeight());
        rect.setArcHeight(32.0);
        rect.setArcWidth(32.0);
        this.layout.setClip((Node)rect);
        this.header = LookupHelper.lookupIfPossible((Node)this.layout, "#header").orElse(null);
        this.sceneBaseInit();
        super.init();
    }

    @Override
    protected abstract void doInit() throws Exception;

    public void showOverlay(AbstractOverlay overlay, EventHandler<ActionEvent> onFinished) throws Exception {
        this.currentOverlay = overlay;
        this.currentOverlay.show(this.currentStage);
        this.showOverlay(overlay.getLayout(), onFinished);
    }

    private void showOverlay(Pane newOverlay, EventHandler<ActionEvent> onFinished) {
        if (newOverlay == null) {
            throw new NullPointerException();
        }
        if (this.currentOverlayNode != null) {
            this.swapOverlay(newOverlay, onFinished);
            return;
        }
        this.currentOverlayNode = newOverlay;
        Pane root = (Pane)this.scene.getRoot();
        this.disable();
        root.getChildren().add((Object)newOverlay);
        newOverlay.setLayoutX((root.getPrefWidth() - newOverlay.getPrefWidth()) / 2.0);
        newOverlay.setLayoutY((root.getPrefHeight() - newOverlay.getPrefHeight()) / 2.0);
        newOverlay.toFront();
        newOverlay.requestFocus();
        AbstractScene.fade((Node)newOverlay, 0.0, 0.0, 1.0, onFinished);
    }

    public void hideOverlay(double delay, EventHandler<ActionEvent> onFinished) {
        if (this.currentOverlayNode == null) {
            return;
        }
        if (this.currentOverlay == null) {
            return;
        }
        if (this.hideTransformStarted && onFinished != null) {
            this.contextHelper.runInFxThread(() -> onFinished.handle(null));
        }
        this.hideTransformStarted = true;
        Pane root = (Pane)this.scene.getRoot();
        AbstractScene.fade(this.currentOverlayNode, delay, 1.0, 0.0, (EventHandler<ActionEvent>)((EventHandler)e -> {
            root.getChildren().remove((Object)this.currentOverlayNode);
            root.requestFocus();
            this.enable();
            this.currentOverlayNode = null;
            if (this.currentOverlay != null) {
                this.currentOverlay.reset();
            }
            this.currentOverlay = null;
            if (onFinished != null) {
                onFinished.handle(e);
            }
            this.hideTransformStarted = false;
        }));
    }

    private void swapOverlay(Pane newOverlay, EventHandler<ActionEvent> onFinished) {
        if (this.currentOverlayNode == null) {
            throw new IllegalStateException("Try swap null overlay");
        }
        if (this.hideTransformStarted && onFinished != null) {
            this.contextHelper.runInFxThread(() -> onFinished.handle(null));
        }
        this.hideTransformStarted = true;
        Pane root = (Pane)this.scene.getRoot();
        AbstractScene.fade(this.currentOverlayNode, 0.0, 1.0, 0.0, (EventHandler<ActionEvent>)((EventHandler)e -> {
            if (this.currentOverlayNode != newOverlay) {
                ObservableList child = root.getChildren();
                int index = child.indexOf((Object)this.currentOverlayNode);
                child.set(index, (Object)newOverlay);
            }
            newOverlay.setLayoutX((root.getPrefWidth() - newOverlay.getPrefWidth()) / 2.0);
            newOverlay.setLayoutY((root.getPrefHeight() - newOverlay.getPrefHeight()) / 2.0);
            this.currentOverlayNode = newOverlay;
            newOverlay.toFront();
            newOverlay.requestFocus();
            AbstractScene.fade((Node)newOverlay, 0.0, 0.0, 1.0, (EventHandler<ActionEvent>)((EventHandler)ev -> {
                this.hideTransformStarted = false;
                if (onFinished != null) {
                    onFinished.handle(ev);
                }
            }));
        }));
    }

    protected final <T extends WebSocketEvent> void processRequest(String message, Request<T> request, Consumer<T> onSuccess, EventHandler<ActionEvent> onError) {
        this.application.gui.processingOverlay.processRequest(this, message, request, onSuccess, onError);
    }

    protected final <T extends WebSocketEvent> void processRequest(String message, Request<T> request, Consumer<T> onSuccess, Consumer<Throwable> onException, EventHandler<ActionEvent> onError) {
        this.application.gui.processingOverlay.processRequest(this, message, request, onSuccess, onException, onError);
    }

    public AbstractOverlay getCurrentOverlay() {
        return this.currentOverlay;
    }

    @Override
    public void disable() {
        LogHelper.debug("Scene %s disabled (%d)", this.getName(), this.enabled.incrementAndGet());
        if (this.enabled.get() != 1) {
            return;
        }
        Pane root = (Pane)this.scene.getRoot();
        if (this.layout == root) {
            throw new IllegalStateException("AbstractScene.disable() failed: layout == root");
        }
        this.layout.setEffect((Effect)new GaussianBlur(5.0));
        if (this.disablePane == null) {
            this.disablePane = new Pane();
            this.disablePane.setPrefHeight(root.getPrefHeight());
            this.disablePane.setPrefWidth(root.getPrefWidth());
            int index = root.getChildren().indexOf((Object)this.layout);
            root.getChildren().add(index + 1, (Object)this.disablePane);
        }
        this.disablePane.setVisible(true);
    }

    @Override
    public void enable() {
        LogHelper.debug("Scene %s enabled (%d)", this.getName(), this.enabled.decrementAndGet());
        if (this.enabled.get() != 0) {
            return;
        }
        this.layout.setEffect((Effect)new GaussianBlur(0.0));
        this.disablePane.setVisible(false);
    }

    public boolean isEnabled() {
        return this.enabled.get() == 0;
    }

    @Override
    public abstract void reset();

    public Scene getScene() {
        return this.scene;
    }

    private void sceneBaseInit() {
        LookupHelper.lookupIfPossible((Node)this.layout, "#deauth").ifPresent(b -> b.setOnAction(e -> this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.scenes.settings.exitDialog.header"), this.application.getTranslation("runtime.scenes.settings.exitDialog.description"), this::userExit, () -> {}, true)));
        this.currentStage.enableMouseDrag((Node)this.layout);
    }

    private ContextMenu makeLangContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getStyleClass().add((Object)"langChoice");
        for (RuntimeSettings.LAUNCHER_LOCALE locale : RuntimeSettings.LAUNCHER_LOCALE.values()) {
            MenuItem item = new MenuItem(locale.displayName);
            item.setOnAction(e -> {
                try {
                    this.application.updateLocaleResources(locale.name);
                    this.application.runtimeSettings.locale = locale;
                    this.application.gui.reload();
                }
                catch (Exception exception) {
                    this.errorHandle(exception);
                }
            });
            contextMenu.getItems().add((Object)item);
        }
        return contextMenu;
    }

    protected void userExit() {
        this.processRequest(this.application.getTranslation("runtime.scenes.settings.exitDialog.processing"), new ExitRequest(), event -> ContextHelper.runInFxThreadStatic(() -> {
            this.hideOverlay(0.0, null);
            this.application.gui.loginScene.clearPassword();
            this.application.gui.loginScene.reset();
            try {
                this.application.saveSettings();
                this.application.stateService.exit();
                this.switchScene(this.application.gui.loginScene);
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        }), (EventHandler<ActionEvent>)((EventHandler)event -> {}));
    }

    protected void switchScene(AbstractScene scene) throws Exception {
        this.currentStage.setScene(scene);
    }

    public Node getHeader() {
        return this.header;
    }

    public static void runLater(double delay, EventHandler<ActionEvent> callback) {
        AbstractScene.fade(null, delay, 0.0, 1.0, callback);
    }
}

