/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.overlays;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Labeled;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.utils.helper.LogHelper;

public class ProcessingOverlay
extends AbstractOverlay {
    private Node spinner;
    private Labeled description;

    public ProcessingOverlay(JavaFXApplication application) {
        super("overlay/processing/processing.fxml", application);
    }

    @Override
    public String getName() {
        return "processing";
    }

    @Override
    protected void doInit() {
        this.description = (Labeled)LookupHelper.lookup((Node)this.layout, "#description");
    }

    @Override
    public void reset() {
        this.description.textProperty().unbind();
        this.description.getStyleClass().remove((Object)"error");
        this.description.setText("...");
    }

    @Override
    public void errorHandle(Throwable e) {
        super.errorHandle(e);
        this.description.textProperty().unbind();
        this.description.getStyleClass().add((Object)"error");
        this.description.setText(e.toString());
    }

    public final <T extends WebSocketEvent> void processRequest(AbstractScene scene, String message, Request<T> request, Consumer<T> onSuccess, EventHandler<ActionEvent> onError) {
        this.processRequest(scene, message, request, onSuccess, null, onError);
    }

    public final <T extends WebSocketEvent> void processRequest(AbstractScene scene, String message, Request<T> request, Consumer<T> onSuccess, Consumer<Throwable> onException, EventHandler<ActionEvent> onError) {
        try {
            scene.showOverlay(this, (EventHandler<ActionEvent>)((EventHandler)e -> {
                try {
                    this.description.setText(message);
                    ((CompletableFuture)this.application.service.request(request).thenAccept(result -> {
                        LogHelper.dev("RequestFuture complete normally");
                        onSuccess.accept(result);
                    })).exceptionally(error -> {
                        if (onException != null) {
                            onException.accept((Throwable)error);
                        }
                        ContextHelper.runInFxThreadStatic(() -> this.errorHandle(error.getCause()));
                        this.hide(2500.0, scene, onError);
                        return null;
                    });
                }
                catch (IOException ex) {
                    this.errorHandle(ex);
                    this.hide(2500.0, scene, onError);
                }
            }));
        }
        catch (Exception e2) {
            this.errorHandle(e2);
        }
    }
}

