/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.impl;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.client.gui.dialogs.ApplyDialog;
import pro.gravit.launcher.client.gui.dialogs.InfoDialog;
import pro.gravit.launcher.client.gui.dialogs.NotificationDialog;
import pro.gravit.launcher.client.gui.dialogs.TextDialog;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.helper.PositionHelper;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.stage.DialogStage;
import pro.gravit.utils.helper.LogHelper;

public class MessageManager {
    public final JavaFXApplication application;
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicInteger localCount = new AtomicInteger(0);

    public MessageManager(JavaFXApplication application) {
        this.application = application;
    }

    public void createNotification(String head, String message) {
        this.createNotification(head, message, this.application.getCurrentScene() != null);
    }

    public void initDialogInScene(AbstractScene scene, AbstractDialog dialog) {
        Pane root = (Pane)scene.getFxmlRoot();
        if (!dialog.isInit()) {
            try {
                dialog.currentStage = scene.currentStage;
                dialog.init();
            }
            catch (Exception e) {
                scene.errorHandle(e);
            }
        }
        Pane dialogRoot = (Pane)dialog.getFxmlRoot();
        dialog.setOnClose(() -> {
            root.getChildren().remove((Object)dialogRoot);
            if (!(dialog instanceof NotificationDialog)) {
                scene.enable();
            }
        });
        if (dialog instanceof NotificationDialog) {
            NotificationDialog.NotificationSlot slot = new NotificationDialog.NotificationSlot(scrollTo -> dialogRoot.setLayoutY(dialogRoot.getLayoutY() + scrollTo), ((Pane)dialog.getFxmlRoot()).getPrefHeight() + 20.0);
            NotificationDialog notificationDialog = (NotificationDialog)dialog;
            notificationDialog.setPosition(PositionHelper.PositionInfo.BOTTOM_RIGHT, slot);
        } else {
            scene.disable();
        }
        LookupHelper.Point2D coords = dialog.getSceneCoords(root);
        dialogRoot.setLayoutX(coords.x);
        dialogRoot.setLayoutY(coords.y);
        LogHelper.info("X: %f Y: %f", coords.x, coords.y);
        root.getChildren().add((Object)dialogRoot);
    }

    public void createNotification(String head, String message, boolean isLauncher) {
        NotificationDialog dialog = new NotificationDialog(this.application, head, message);
        if (isLauncher) {
            AbstractScene scene = this.application.getCurrentScene();
            if (scene == null) {
                throw new NullPointerException("Try show launcher notification in application.getCurrentScene() == null");
            }
            ContextHelper.runInFxThreadStatic(() -> this.initDialogInScene(scene, dialog));
        } else {
            AtomicReference<Object> stage = new AtomicReference<Object>(null);
            ContextHelper.runInFxThreadStatic(() -> {
                NotificationDialog.NotificationSlot slot = new NotificationDialog.NotificationSlot(scrollTo -> ((DialogStage)stage.get()).stage.setY(((DialogStage)stage.get()).stage.getY() + scrollTo), ((Pane)dialog.getFxmlRoot()).getPrefHeight() + 20.0);
                dialog.setPosition(PositionHelper.PositionInfo.BOTTOM_RIGHT, slot);
                dialog.setOnClose(() -> {
                    ((DialogStage)stage.get()).close();
                    ((DialogStage)stage.get()).stage.setScene(null);
                });
                stage.set(new DialogStage(this.application, head, dialog));
                ((DialogStage)stage.get()).show();
            });
        }
    }

    public void showDialog(String header, String text, Runnable onApplyCallback, Runnable onCloseCallback, boolean isLauncher) {
        InfoDialog dialog = new InfoDialog(this.application, header, text, onApplyCallback, onCloseCallback);
        this.showAbstractDialog(dialog, header, isLauncher);
    }

    public void showApplyDialog(String header, String text, Runnable onApplyCallback, Runnable onDenyCallback, boolean isLauncher) {
        this.showApplyDialog(header, text, onApplyCallback, onDenyCallback, onDenyCallback, isLauncher);
    }

    public void showApplyDialog(String header, String text, Runnable onApplyCallback, Runnable onDenyCallback, Runnable onCloseCallback, boolean isLauncher) {
        ApplyDialog dialog = new ApplyDialog(this.application, header, text, onApplyCallback, onDenyCallback, onCloseCallback);
        this.showAbstractDialog(dialog, header, isLauncher);
    }

    public void showTextDialog(String header, Consumer<String> onApplyCallback, Runnable onCloseCallback, boolean isLauncher) {
        TextDialog dialog = new TextDialog(this.application, header, "", onApplyCallback, onCloseCallback);
        this.showAbstractDialog(dialog, header, isLauncher);
    }

    public void showAbstractDialog(AbstractDialog dialog, String header, boolean isLauncher) {
        if (isLauncher) {
            AbstractScene scene = this.application.getCurrentScene();
            if (scene == null) {
                throw new NullPointerException("Try show launcher dialog in application.getCurrentScene() == null");
            }
            ContextHelper.runInFxThreadStatic(() -> this.initDialogInScene(scene, dialog));
        } else {
            AtomicReference<Object> stage = new AtomicReference<Object>(null);
            ContextHelper.runInFxThreadStatic(() -> {
                stage.set(new DialogStage(this.application, header, dialog));
                ((DialogStage)stage.get()).show();
            });
            dialog.setOnClose(() -> {
                ((DialogStage)stage.get()).close();
                ((DialogStage)stage.get()).stage.setScene(null);
            });
        }
    }
}

