/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.impl;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.HashSet;
import java.util.Set;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.impl.ContextHelper;
import pro.gravit.launcher.client.gui.overlays.AbstractOverlay;
import pro.gravit.launcher.client.gui.overlays.ProcessingOverlay;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.debug.DebugScene;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.options.OptionsScene;
import pro.gravit.launcher.client.gui.scenes.serverinfo.ServerInfoScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.client.gui.scenes.settings.SettingsScene;
import pro.gravit.launcher.client.gui.scenes.update.UpdateScene;
import pro.gravit.utils.helper.LogHelper;

public class GuiObjectsContainer {
    private final JavaFXApplication application;
    private final Set<AbstractOverlay> overlays = new HashSet<AbstractOverlay>();
    private final Set<AbstractScene> scenes = new HashSet<AbstractScene>();
    public ProcessingOverlay processingOverlay;
    public UpdateScene updateScene;
    public DebugScene debugScene;
    public ServerMenuScene serverMenuScene;
    public ServerInfoScene serverInfoScene;
    public LoginScene loginScene;
    public OptionsScene optionsScene;
    public SettingsScene settingsScene;

    public GuiObjectsContainer(JavaFXApplication application) {
        this.application = application;
    }

    public void init() {
        this.loginScene = this.registerScene(LoginScene.class);
        this.processingOverlay = this.registerOverlay(ProcessingOverlay.class);
        this.serverMenuScene = this.registerScene(ServerMenuScene.class);
        this.serverInfoScene = this.registerScene(ServerInfoScene.class);
        this.optionsScene = this.registerScene(OptionsScene.class);
        this.settingsScene = this.registerScene(SettingsScene.class);
        this.updateScene = this.registerScene(UpdateScene.class);
        this.debugScene = this.registerScene(DebugScene.class);
    }

    public void reload() throws Exception {
        Class<?> scene = this.application.getCurrentScene().getClass();
        ContextHelper.runInFxThreadStatic(() -> {
            this.application.getMainStage().stage.setScene(null);
            this.application.resetDirectory();
            this.overlays.clear();
            this.scenes.clear();
            this.init();
            for (AbstractScene s : this.scenes) {
                if (s.getClass() != scene) continue;
                this.application.getMainStage().setScene(s);
            }
        }).get();
    }

    public AbstractScene getSceneByName(String name) {
        for (AbstractScene scene : this.scenes) {
            if (!name.equals(scene.getName())) continue;
            return scene;
        }
        return null;
    }

    public AbstractOverlay getOverlayByName(String name) {
        for (AbstractOverlay overlay : this.overlays) {
            if (!name.equals(overlay.getName())) continue;
            return overlay;
        }
        return null;
    }

    public <T extends AbstractOverlay> T registerOverlay(Class<T> clazz) {
        try {
            AbstractOverlay instance = (AbstractOverlay)MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE, JavaFXApplication.class)).invokeWithArguments(new Object[]{this.application});
            this.overlays.add(instance);
            return (T)instance;
        }
        catch (Throwable e) {
            LogHelper.error(e);
            throw new RuntimeException(e);
        }
    }

    public <T extends AbstractScene> T registerScene(Class<T> clazz) {
        try {
            AbstractScene instance = (AbstractScene)MethodHandles.publicLookup().findConstructor(clazz, MethodType.methodType(Void.TYPE, JavaFXApplication.class)).invokeWithArguments(new Object[]{this.application});
            this.scenes.add(instance);
            return (T)instance;
        }
        catch (Throwable e) {
            LogHelper.error(e);
            throw new RuntimeException(e);
        }
    }
}

