/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.impl;

import java.util.UUID;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;
import pro.gravit.launcher.client.gui.scenes.login.LoginScene;
import pro.gravit.launcher.client.gui.scenes.options.OptionsScene;
import pro.gravit.launcher.client.gui.scenes.serverinfo.ServerInfoScene;
import pro.gravit.launcher.client.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.client.gui.scenes.settings.SettingsScene;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.utils.helper.LogHelper;

public class GuiEventHandler
implements RequestService.EventHandler {
    private final JavaFXApplication application;

    public GuiEventHandler(JavaFXApplication application) {
        this.application = application;
    }

    @Override
    public <T extends WebSocketEvent> boolean eventHandle(T event) {
        block9: {
            LogHelper.dev("Processing event %s", event.getType());
            if (event instanceof RequestEvent && !((RequestEvent)event).requestUUID.equals(RequestEvent.eventUUID)) {
                return false;
            }
            try {
                AbstractScene scene;
                if (event instanceof AuthRequestEvent) {
                    boolean isNextScene = this.application.getCurrentScene() instanceof LoginScene;
                    ((LoginScene)this.application.getCurrentScene()).isLoginStarted = true;
                    LogHelper.dev("Receive auth event. Send next scene %s", isNextScene ? "true" : "false");
                    this.application.stateService.setAuthResult(null, (AuthRequestEvent)event);
                    if (isNextScene && ((LoginScene)this.application.getCurrentScene()).isLoginStarted) {
                        ((LoginScene)this.application.getCurrentScene()).onGetProfiles();
                    }
                }
                if (!(event instanceof ProfilesRequestEvent)) break block9;
                this.application.stateService.setProfilesResult((ProfilesRequestEvent)event);
                if (this.application.stateService.getProfile() != null) {
                    UUID profileUUID = this.application.stateService.getProfile().getUUID();
                    for (ClientProfile profile : this.application.stateService.getProfiles()) {
                        if (!profile.getUUID().equals(profileUUID)) continue;
                        this.application.stateService.setProfile(profile);
                        break;
                    }
                }
                if (!((scene = this.application.getCurrentScene()) instanceof ServerMenuScene) && !(scene instanceof ServerInfoScene)) {
                    if (!(scene instanceof SettingsScene | scene instanceof OptionsScene)) break block9;
                }
                scene.contextHelper.runInFxThread(scene::reset);
            }
            catch (Throwable e) {
                LogHelper.error(e);
            }
        }
        return false;
    }
}

