/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.impl;

import java.util.concurrent.atomic.AtomicReference;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import pro.gravit.launcher.client.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.client.gui.scenes.AbstractScene;

public abstract class AbstractStage {
    public final Stage stage;
    protected AbstractVisualComponent scene;

    protected AbstractStage(Stage stage) {
        this.stage = stage;
    }

    public void hide() {
        this.stage.setIconified(true);
    }

    public void close() {
        this.stage.hide();
    }

    public void enableMouseDrag(Node node) {
        AtomicReference movePoint = new AtomicReference();
        node.setOnMousePressed(event -> movePoint.set(new Point2D(event.getSceneX(), event.getSceneY())));
        node.setOnMouseDragged(event -> {
            if (movePoint.get() == null) {
                return;
            }
            this.stage.setX(event.getScreenX() - ((Point2D)movePoint.get()).getX());
            this.stage.setY(event.getScreenY() - ((Point2D)movePoint.get()).getY());
        });
    }

    public AbstractVisualComponent getVisualComponent() {
        return this.scene;
    }

    public void setScene(AbstractVisualComponent visualComponent) throws Exception {
        if (visualComponent == null) {
            throw new NullPointerException("Try set null scene");
        }
        visualComponent.currentStage = this;
        if (!visualComponent.isInit()) {
            visualComponent.init();
        }
        if (visualComponent.isResetOnShow) {
            visualComponent.reset();
        }
        if (visualComponent instanceof AbstractScene) {
            this.stage.setScene(((AbstractScene)visualComponent).getScene());
        } else {
            Scene scene = new Scene((Parent)visualComponent.layout);
            scene.setFill((Paint)Color.TRANSPARENT);
            this.stage.setScene(scene);
        }
        this.stage.sizeToScene();
        this.scene = visualComponent;
    }

    public boolean isShowing() {
        return this.stage.isShowing();
    }

    public final boolean isNullScene() {
        return this.scene == null;
    }

    public void show() {
        this.stage.show();
    }
}

